package com.sams.jws.chapter15;
/*
 * HelloWorldSender
 * Bardzo prosty przykad profilu JAXM SOAP bez cznika. 
 * Demonstracja synchronicznego dania w modelu klient-serwer.
 */
// Oglne JDK
import java.io.IOException;
// JAXM
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPPart;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import javax.xml.messaging.URLEndpoint;

public class HelloWorldSender {

    public static void main(String args[]) {

        URLEndpoint urlEndpoint = null;
        if (args.length == 1)
            urlEndpoint = new URLEndpoint(args[0]);
        else {
            System.err.println("Polecenie: java HelloWorldSender targetURL");
            System.exit(0);
        } // Else

        try {
            // Inicjalizacja poczenia i profilu SOAP.
            System.out.println("Otwieranie poczenia...");
            SOAPConnectionFactory soapConnFct = SOAPConnectionFactory.newInstance();
            SOAPConnection soapConnection = soapConnFct.createConnection();

            System.out.println("Tworzenie komunikatu...");
            MessageFactory messageFactory = MessageFactory.newInstance();
            SOAPMessage requestSoapMsg = messageFactory.createMessage();

            // Tworzenie odwoa do komponentw komunikatu SOAP
            SOAPPart requestSoapPart = requestSoapMsg.getSOAPPart();
            SOAPEnvelope requestSoapEnv = requestSoapPart.getEnvelope();
            SOAPHeader requestSoapHdr = requestSoapEnv.getHeader();

            // Doczanie pola nagwka. Pola nagwka s opcjonalne.
            Name questionName = requestSoapEnv.createName("Question");
            SOAPHeaderElement questionElement =
                requestSoapHdr.addHeaderElement(questionName);
            questionElement.setMustUnderstand(true);
            questionElement.addTextNode("Puk, puk?");

            /*
            * Naley pamita, e element ciaa nie zosta zdefiniowany. 
            * Poniewa jest to pole obowizkowe, JAXM 
            * niejawnie utworzy pusty element ciaa.
            */

            // Zapisanie wszystkich zmian dokonanych w komunikacie przed wydrukiem. 
            // Wysanie take niejawnie zapisze zmiany.
            requestSoapMsg.saveChanges();

            System.out.println("HelloWorldSender wysya nastpujcy komunikat:");
            try {
                requestSoapMsg.writeTo(System.out);
            } catch (IOException e) {
                System.err.println(
                    "Wyjtek IOException przy prbie zapisu SOAPMessage do urzdzenia System.out: ");
                e.printStackTrace();
            }
            System.out.println("\nNa adres URL: ");
            System.out.println(urlEndpoint.getURL() + "\n");

            // Wylij danie i zablokuj aplikacj do momentu otrzymania odpowiedzi.
            SOAPMessage responseSoapMsg = soapConnection.call(requestSoapMsg, urlEndpoint);

            System.out.println("Aplikacja HelloWorldSender otrzymaa nastpujcy komunikat odpowiedzi:");
            try {
                responseSoapMsg.writeTo(System.out);
                System.out.println("\n");
            } catch (IOException e) {
                System.err.println(
                    "Wyjtek IOException przy prbie zapisu SOAPMessage do urzdzenia System.out: ");
                e.printStackTrace();
            }

            // Porzdki
            soapConnection.close();
            System.out.println("Poczenie zamknite.");

        } catch (SOAPException e) {
            System.err.println("Wystpi oglny wyjtek SOAPException: ");
            e.printStackTrace();
        }
        System.out.println("Gotowe.");
    } // main()
} // HelloWorldSender
