package com.sams.jws.chapter15;
/**
 * FileElement
 * Klasa osony dla typu java.io.File. Osona przeprowadza szeregowanie samej siebie 
 * do dokumentu JAXM XML.
 */
import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

public class FileElement {
    private java.io.File file = null;
public FileElement(File file) {
    this.file=file;
}    // FileElement constructor
public java.io.File getFile() {
    return file;
}    // getFile
/**
 * marshalFile
 * Tworzenie reprezentacji XML pliku w oparciu o soapElement.
 */
public void marshalFile(SOAPElement soapElement) throws SOAPException {

    // Create an XML subdocument describing the characteristics  
    // of the file, as represented by the File object.
    SOAPElement fileElement = soapElement.addChildElement("File");
    fileElement.addChildElement("Name").addTextNode(file.getName());
    fileElement.addChildElement("Path").addTextNode(file.getPath());
    fileElement.addChildElement("AbsolutePath")
               .addTextNode(file.getAbsolutePath());
    try {
        fileElement.addChildElement("CanonicalPath")
                   .addTextNode(file.getCanonicalPath());
    } catch (IOException e){
    // Just leave out CanonicalPath element if the IOException is thrown.   
    }
    fileElement.addChildElement("IsDirectory")
               .addTextNode(String.valueOf(file.isDirectory()));
    fileElement.addChildElement("IsFile")
               .addTextNode(String.valueOf(file.isFile()));
    fileElement.addChildElement("LastModified")
               .addTextNode(new Date(file.lastModified()).toString());
    fileElement.addChildElement("Length")
               .addTextNode(String.valueOf(file.length()));
    fileElement.addChildElement("CanRead")
               .addTextNode(String.valueOf(file.canRead()));
    fileElement.addChildElement("CanWrite")
               .addTextNode(String.valueOf(file.canWrite()));
    fileElement.addChildElement("IsHidden")
               .addTextNode(String.valueOf(file.isHidden()));
}    // marshalFile
public void setFile(java.io.File newFile) {
    file = newFile;
}    // setFile
}    // FileElement
