package com.sams.jws.chapter15;
/**
 * DocumentUtils
 * Metody pomocnicze umoliwiajce prac z dokumentami JAXM SOAP
 */
import java.util.Iterator;
import javax.xml.soap.SOAPElement;

public class DocumentUtils {
/**
 * Konstruktor prywatny uniemoliwia tworzenie instancji oraz rozszerze klas 
 * pomocniczych.
 */
private DocumentUtils() {}
/**
 * findChild
 * Zwraca element SOAPElement reprezentujcy bezporedni wze potomny wza gwnego 
 * wskazany w childName. Metoda rozrnia mae i wielkie litery.
 */
public static SOAPElement findChild(SOAPElement root, String childName) {
    Iterator i = root.getChildElements();
    while (i.hasNext()) {
        SOAPElement soapElement = (SOAPElement) i.next();
        if (soapElement.getElementName().getLocalName().equals(childName))
            return soapElement;
    } 
    return null;
}  // findChild()
/**
 * findValueOfChild
 * Zwraca element SOAPElement reprezentujcy bezporedni wze potomny wza gwnego 
 * wskazany w childName. Jeeli wze potomny jest wzem tekstowym, zwracana jest jego 
 * warto. W przeciwnym wypadku zwracana jest warto null.
 *
 * Na przykad dla: <Foo> bar </Foo> gdzie Foo jest korzeniem, zwracana jest warto 
 * bar.
 * Metoda childName rozrnia mae i wielkie litery.
 */
public static String findValueOfChild(SOAPElement root, String childName) {
    SOAPElement childElement = findChild(root, childName);
    if (childElement == null) {
        return null;
    }
    return childElement.getValue();
}  // findValueOfChild()
}  // DocumentUtils
