import javax.xml.registry.*;
import javax.xml.registry.infomodel.*;
import javax.naming.*;
import java.util.*;

public class DoQueries
{
    public static void main(String[] args)
    {
        try
        {
            Context ctx = new InitialContext();

            ConnectionFactory factory =
                (ConnectionFactory) ctx.lookup(
                    "javax.xml.registr.ConnectionFactory");
            
            Properties props = new Properties();

// Okrelenie implementacji dla rzeczywistego konstruktora poczenia
            props.put("javax.xml.registry.factoryClass",
                "com.sun.xml.registry.uddi.ConnectionFactoryImpl");

// Okrelenie lokalizacji API zapyta i API rejestracji
            props.put("javax.xml.registry.queryManagerURL",
                "www-3.ibm.com/services/uddi/testregistry/inquiryapi");
            props.put("javax.xml.registry.lifeCycleManagerURL",
                "www-3.ibm.com/services/uddi/testregistry/publish");

// Zapisanie waciwoci w konstruktorze
            factory.setProperties(props);

// Utworzenie poczenia
            Connection conn = factory.createConnection();

// Tworzenie RegistryService
            RegistryService regService = conn.getRegistryService();

// Tworzenie BusinessQueryManager
            BusinessQueryManager query =
                regService.getBusinessQueryManager();

// Poszukiwanie przedsibiorstw o nazwie Microsoft
            ArrayList namePatterns = new ArrayList();
            namePatterns.add("Microsoft");

// Wykonanie zapytania
            BulkResponse response = query.findOrganizations(
                null, namePatterns, null, null, null, null);

// Pobranie kolekcji zawierajcej odpowied
            Collection respData = response.getCollection();

            Iterator iter = respData.iterator();

            System.out.println("Organizacje pasujce do nazwy Microsoft:");
// Przebieganie odpowiedzi
            while (iter.hasNext())
            {
// Pobranie nastpnej jednostki organizacyjnej
                Organization org = (Organization) iter.next();

                System.out.println("Organizacja: "+org.getName());
                System.out.println(org.getDescription());
                System.out.println();

// Pobranie klucza danej jednostki organizacyjnej
                Key orgKey = org.getKey();

// Wyszukanie wszystkich usug w ofercie danej jednostki organizacyjnej
                BulkResponse servResp =
                    query.findServices(orgKey, null, null, null, null);
                
// Pobranie listy wszystkich usug
                Collection services = servResp.getCollection();

                Iterator servIter = services.iterator();

                System.out.println("Services:");

// Przebieganie usug
                while (servIter.hasNext())
                {
                    Service service = (Service) servIter.next();

                    System.out.println("Service: "+service.getName());

                    Collection bindings = service.getServiceBindings();

                    Iterator bindIter = bindings.iterator();

// Przebieganie przez wizania usug
                    while (bindIter.hasNext())
                    {
                        ServiceBinding binding =
                            (ServiceBinding) bindIter.next();
                        
                        System.out.println(binding.getAccessURI());
                    }
                    System.out.println();
                }

            }

        }
        catch (Exception exc)
        {
            exc.printStackTrace();
        }
    }
}
