import javax.xml.registry.*;
import javax.xml.registry.infomodel.*;
import javax.naming.*;
import java.util.*;

public class CreateOrg
{
    public static void main(String[] args)
    {
        try
        {
            Context ctx = new InitialContext();

            ConnectionFactory factory =
                (ConnectionFactory) ctx.lookup(
                    "javax.xml.registr.ConnectionFactory");
            
            Properties props = new Properties();

// Wskazanie implementacji rzeczywistego konstruktora pocze
            props.put("javax.xml.registry.factoryClass",
                "com.sun.xml.registry.uddi.ConnectionFactoryImpl");

// Wskazanie lokalizacji API zapyta oraz API rejestracji
            props.put("javax.xml.registry.queryManagerURL",
                "www-3.ibm.com/services/uddi/testregistry/inquiryapi");
            props.put("javax.xml.registry.lifeCycleManagerURL",
                "www-3.ibm.com/services/uddi/testregistry/publish");

// Zapisanie waciwoci w konstruktorze
            factory.setProperties(props);

// Utworzenie obiektu Connection
            Connection conn = factory.createConnection();

// Utworzenie obiektu RegistryService
            RegistryService regService = conn.getRegistryService();

// Utworzenie obiektu BusinessQueryManager
            BusinessLifeCycleManager lifeCycle =
                regService.getBusinessLifeCycleManager();

// Utworzenie nowej jednostki organizacyjnej
            Organization newOrg = lifeCycle.createOrganization(
                "WebServCorp");

// Opis jednostki organizacyjnej (musi opiera si na cigu  bez znakw diakrytycznych)
            newOrg.setDescription(
                lifeCycle.createInternationalString(
                    "Providing Web services to the world"));

            ArrayList save = new ArrayList();

// Doczenie jednostki do kolekcji
            save.add(newOrg);

// Zapisanie kolekcji
            BulkResponse resp = lifeCycle.saveObjects(save);

// Pobranie danych odpowiedzi
            Collection respColl = resp.getCollection();

            Iterator iter = respColl.iterator();

// Pobranie klucza wygenerowanego dla nowej jednostki organizacyjnej
            Key key = (Key) iter.next();

            System.out.println("The organization's key is "+
                key.getId());
        }
        catch (Exception exc)
        {
            exc.printStackTrace();
        }
    }
}
