import java.io.*;
import java.util.*;
import javax.xml.bind.*;
import javax.xml.marshal.*;

public class TestClient
{
    public static void pokaKsiki( List listaKsiek )
    {
        for( Iterator i=listaKsiek.iterator(); i.hasNext(); )
        {
            Ksika ksika = ( Ksika )i.next();
            System.out.println( "Ksika: " + 
                                ksika.getTytu() + ", " + 
                                ksika.getAutor() + ", " +
                                ksika.getCena() + ", " +
                                ksika.getKategoria() );
        }
    }
    
    public static void main( String[] args )
    {
        try
        {
      // Otwrz plik book.xml
            File plik = new File( "book.xml" );
            if( !plik.exists() )
            {
                System.out.println( "Nie znaleziono pliku..." );
                return;
            }
            FileInputStream fis = new FileInputStream( plik );
            Ksiki ksiki = Ksiki.unmarshal( fis );
            fis.close();

      // Poka pierwotn zawarto pliku
            pokaKsiki( ksiki.getKsika() );

            // Docz ksik
            System.out.println( "\nDodawanie ksiki" );
            Ksika ksika = new Ksika();
            ksika.setTytu( "Java w komercyjnych usugach sieciowych" );
            ksika.setAutor( "Kilku facetw" );
            ksika.setCena( "49.95" );
            ksika.setKategoria( "Computer Programming" );
            ksiki.getKsika().add( ksika );

      // Poka zaktualizowan zawarto dokumentu XML
            pokaKsiki( ksiki.getKsika() );

      // Wywietl na ekranie kompletny dokument XML
            XMLWriter writer = new XMLWriter( System.out, "US-ASCII", true );
            ksiki.validate();
            ksiki.marshal( writer );
        }
        catch( Exception e )
        {
            e.printStackTrace();
        }
        
    }
}
