import javax.xml.parsers.DocumentBuilder; 
import javax.xml.parsers.DocumentBuilderFactory;  
import javax.xml.parsers.FactoryConfigurationError;  
import javax.xml.parsers.ParserConfigurationException;

import org.xml.sax.SAXException;  
import org.xml.sax.SAXParseException;

import java.io.FileInputStream;
import java.io.File;
import java.io.IOException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import org.w3c.dom.DOMException;
import org.w3c.dom.Text;

public class DOMSample2
{
    public static void main( String[] args )
    {
        try
        {
            File plik = new File( "book.xml" );
            if( !plik.exists() )
            {
                System.out.println( "Nie znaleziono pliku..." );
                return;
            }

    // Analizuj dokument
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document dokument = builder.parse( plik );

            // Znajd element pierwotny dokumentu 
            Element korze = dokument.getDocumentElement();

    // Utwrz now ksik 
    Element nowyAutor = dokument.createElement( "autor" );
    Text autorTekst = dokument.createTextNode( "Tim Lahaye" );
    nowyAutor.appendChild( autorTekst );
    Element nowyTytu = dokument.createElement( "tytu" );
    Text titleText = dokument.createTextNode( "Desecration" );
    nowyTytu.appendChild( titleText );
    Element nowaCena = dokument.createElement( "cena" );
    Text cenaTekst = dokument.createTextNode( "19.95" );
    nowaCena.appendChild( cenaTekst );
    Element nowaKsika = dokument.createElement( "ksika" );
    nowaKsika.setAttribute( "kategoria", "fiction" );
    nowaKsika.appendChild( nowyAutor );
    nowaKsika.appendChild( nowyTytu );
    nowaKsika.appendChild( nowaCena );

    // Dodaj ksik do elementu pierwotnego
    korze.appendChild( nowaKsika );

    // Wywietl dokument
    System.out.println( korze );
        } catch( Exception e )
        {
            e.printStackTrace();
        }
    }
}
