import javax.swing.*;
import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.net.URL;
import java.net.MalformedURLException ;

public class LoveZone extends JApplet {
  
  private String soundFile = "hello.wav" ;
  private String imageFile = "rjb.jpg" ;
  
  private boolean inAnApplet = true;
  
  private JButton playButton ;
  private JButton stopButton;
  private JLabel label ;
  private JLabel lPhoto ;
  private AudioClip audioClip ;
  private ImageIcon icon ;
  
  public LoveZone() {
    this(true);
  }
  
  public LoveZone(boolean inAnApplet) {
    this.inAnApplet = inAnApplet;
    
    try{
      
      audioClip = newAudioClip(new URL("http://localhost:8080/jws/hello.wav")) ;
      icon = new ImageIcon(new URL("http://localhost:8080/jws/rjb.jpg")) ;
      
    }catch(MalformedURLException ex) {
      System.exit(0) ;
    }
  }
  
  public void init() {
    
    if(audioClip == null)
      audioClip = getAudioClip(getCodeBase(), soundFile);
    try{
      
      icon = new ImageIcon(new URL(getCodeBase(), imageFile)) ;
      
    }catch(MalformedURLException ex) {
      System.exit(0) ;
    }
    
    setContentPane(makeContentPane());
  }
  
  public Container makeContentPane() {
    
    label = new JLabel("Pozdrowienia z LoveZone", JLabel.CENTER);
    
    playButton = new JButton("Suchaj");
    playButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent event) {
        audioClip.play() ;
        playButton.setEnabled(false);
        stopButton.setEnabled(true);
        return;
      }
    }) ;
    
    stopButton = new JButton("Stop");
    stopButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent event) {
        audioClip.stop();
        playButton.setEnabled(true);
        stopButton.setEnabled(false);
        return;
      }
    }) ;
    
    stopButton.setEnabled(false);
    
    lPhoto = new JLabel("", icon, JLabel.CENTER) ;
    
    lPhoto.setToolTipText("Cze, jestem Robert") ;
    lPhoto.setPreferredSize(new Dimension(220, 300)) ;
    
    JPanel controlPanel = new JPanel();
    
    controlPanel.setLayout(new BorderLayout());

    controlPanel.add(label, BorderLayout.SOUTH) ;
    controlPanel.add(playButton, BorderLayout.WEST);
    controlPanel.add(stopButton, BorderLayout.EAST);
    controlPanel.add(lPhoto, BorderLayout.NORTH) ;
    
    controlPanel.setBackground(new Color(255,255,204));
    controlPanel.setBorder(BorderFactory.createMatteBorder(1,1,2,2,Color.black));
    
    return(controlPanel) ;
  }
  
  public static void main(String[] args){
    
    try{
      
      UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel") ;
      
    }catch(Exception e){
      System.err.println("\nERROR When Setting the Metal Look and Feel: ");
      System.err.println(e.getMessage());
    }
    
    Frame frame = new Frame("Love Zone - przykad") ;
    
    frame.addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
        System.exit(0);
      }
    });
    
    LoveZone applet = new LoveZone(false);
    
    frame.add(applet.makeContentPane());
    frame.pack();
    frame.setVisible(true);
  }
}