package jwsunleashed.trading.ejb;

import java.rmi.*;
import java.util.*;
import javax.ejb.*;
import java.sql.*;
import javax.sql.*;
import javax.naming.*;
import java.util.Date;

public abstract class PutOrderImpl extends AutoKeyEJB
{
/** An EJB must have a public, parameterless constructor */

    public PutOrderImpl()
    {
    }

    public String getKeyDatabaseName() { return "TradingDB"; }
    public String getKeyTableName() { return "PUT_ORDER_ID_SEQ"; }
    public String getKeyColumnName() { return "PUT_ORDER_ID"; }

/** Called by the EJB container when a client calls the create() method in
    the home interface */

    public Integer ejbCreate()
        throws CreateException
    {
        try
        {
// compute the new primary key for this object
            setPutOrderId(getNextId());

            return null;
        }
        catch (SQLException exc)
        {
            exc.printStackTrace();
            throw new CreateException(
                "Unable to access database: "+exc.toString());
        }
    }

// Implement the get/set methods for all the data elements

    public abstract int getPutOrderId();
    public abstract void setPutOrderId(int aPutOrderId);

    public abstract int getSellerID();
    public abstract void setSellerID(int aSellerID);

    public abstract String getStock();
    public abstract void setStock(String aStock);

    public abstract int getShares();
    public abstract void setShares(int numShares);

    public abstract int getPrice();
    public abstract void setPrice(int thePrice);

    public abstract Date getPutTime();
    public abstract void setPutTime(Date aTransTime);
}
