import java.util.Date;
import java.util.TimeZone;
import java.util.GregorianCalendar;
import java.text.DateFormat;
/**
 * TimeServer
 * Udostpnia usug synchronizacji czasu dla rozproszonych aplikacji klienckich.
 */
public class TimeServer {

    public long synchronizeTime() {
        System.out.println("Wywoanie synchronizeTime()");
        return (new Date()).getTime();
    }

    public String getTimeAtCity(String zoneName) {
        System.out.println("Wywoanie getTimeAtCity(" + zoneName + ")");
        TimeZone timeZone = TimeZone.getTimeZone(zoneName);
        GregorianCalendar gc = new GregorianCalendar(timeZone);
        DateFormat df =
            DateFormat.getDateTimeInstance(DateFormat.FULL, DateFormat.FULL);
        df.setCalendar(gc);
        String timeAtCity = df.format(gc.getTime());
        return timeAtCity;
    }
} // class TimeServer
