import java.security.*;
import java.security.interfaces.*;
import java.io.*;

/** Obliczenie podpisu cyfrowego dla pliku */

public class SignData
{
    public static void main(String[] args)
    {
        try
        {
            String keystorePassword = "mykspass";
            String testAlias = "signkey";
            String testKeyPassword = "mykeypass";

// Tworzenie bazy kluczy keystore.
            KeyStore keystore = KeyStore.getInstance("JKS");

// Sprawdzenie gdzie znajduje si baza keystore uytkownika.
            String keystoreFilename = System.getProperty("user.home")+
                File.separator+".keystore";
                
// Pobranie keystore z pliku.
            keystore.load(new FileInputStream(keystoreFilename),
                keystorePassword.toCharArray());

// Lokalizacja klucza ze wskazan nazw i hasem.
            Key testkey = keystore.getKey(testAlias,
                testKeyPassword.toCharArray());

// Wskazanie, e klucz ten jest kluczem RSA.
            RSAPrivateKey pvtKey = (RSAPrivateKey) testkey;

// Pobranie certyfikatu dla tego klucza (nie na potrzeby wyliczenia podpisu,
// ale do zapisania w oddzielnym pliku do pniejszej weryfikacji podpisu).
            java.security.cert.Certificate cert =
                keystore.getCertificate(testAlias);

// Tworzenie i inicjalizacja obiektu podpisu stosujcego Md5 i RSA.
            Signature signer = Signature.getInstance("MD5withRSA");
            signer.initSign(pvtKey);

// Otwarcie pliku z danymi.
            FileInputStream in = new FileInputStream(args[0]);

// Utworzenie bloku bajtowego do wczytania pliku.
            byte[] buffer = new byte[4096];
            int len;

// Wczytanie bloku pliku i dodanie go do obiektu podpisu.
            while ((len = in.read(buffer)) > 0)
            {
                signer.update(buffer, 0, len);
            }
            in.close();

// Wyliczenie podpisu cyfrowego.
            byte signatureBytes[] = signer.sign();

// Zapisanie podpisu w pliku.
            FileOutputStream out = new FileOutputStream(args[0]+".sig");
            out.write(signatureBytes);
            out.close();

// Zapisanie zaszyfrowanego certyfikatu w pliku.
            out = new FileOutputStream(args[0]+".cer");
            out.write(cert.getEncoded());
            out.close();
        }
        catch (Exception exc)
        {
            exc.printStackTrace();
        }
    }
}
