import java.io.*;
import java.util.*;
import javax.xml.bind.*;
import javax.xml.marshal.*;
import java.math.BigDecimal;

public class TestClient2
{
    public static void showKsiki( List ksikaList )
    {
        for( Iterator i=ksikaList.iterator(); i.hasNext(); )
        {
            Ksika ksika = ( Ksika )i.next();
            System.out.println( "Ksika: " + 
                                ksika.getTytu() + ", " + 
                                ksika.getAutor() + ", " +
                                ksika.getCena() + ", " +
                                ksika.getKategoria() );
        }
    }
    
    public static void main( String[] args )
    {
        try
        {
	    // Otwrz plik book.xml
            File plik = new File( "ksika.xml" );
            if( !plik.exists() )
            {
                System.out.println( "Nie znaleziono pliku..." );
                return;
            }
            FileInputStream fis = new FileInputStream( plik );
            Ksiki Ksiki = Ksiki.unmarshal( fis );
            fis.close();

	    // Poka pierwotn zawarto pliku
            showKsiki( Ksiki.getKsika() );

            // Docz ksik
            System.out.println( "\nDodawanie ksiki" );
            Ksika ksika = new Ksika();
            ksika.setTytu( "Java w komercyjnych usugach sieciowych" );
            ksika.setAutor( "Kilku facetw" );
            ksika.setCena( new BigDecimal( 49.95 ) );
            ksika.setKategoria( KategoriaType.COMPUTER_PROGRAMMING );
            Ksiki.getKsika().add( ksika );

	    // Poka zaktualizowan zawarto dokumentu XML
            showKsiki( Ksiki.getKsika() );

	    // Wywietl na ekranie kompletny dokument XML
            XMLWriter writer = new XMLWriter( System.out, "US-ASCII", true );
            Ksiki.validate();
            Ksiki.marshal( writer );
        }
        catch( Exception e )
        {
            e.printStackTrace();
        }
        
    }
}

