import java.io.*;
import org.xml.sax.*;
import org.xml.sax.helpers.DefaultHandler;
import javax.xml.parsers.SAXParserFactory;  
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;

public class SAXSample
{
    public static void main( String[] args )
    {
        try
        {
            File plik = new File( "book.xml" );
            if( !plik.exists() )
            {
                System.out.println( "Brak pliku..." );
                return;
            }

            // Zastosuj domylny parser (bez walidacji)
            SAXParserFactory factory = SAXParserFactory.newInstance();

            // Utwrz instancj programu obsugi
            MyHandler handler = new MyHandler();

            // Analizuj plik 
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse( plik, handler );
            SAXBooks ksiki = handler.getKsiki();

            for( int i=0; i<ksiki.getRozmiar(); i++ )
            {
                SAXBook ksika = ksiaki.getKsika( i );
                System.out.println( ksika ); 
            }

        } catch( Throwable t )
        {
            t.printStackTrace();
        }
    }
}
