import org.xml.sax.*;
import org.xml.sax.helpers.DefaultHandler;

public class MyHandler extends DefaultHandler
{
    private SAXBooks books; 
    private boolean readingAutor;
    private boolean readingTytu;
    private boolean readingCena;

    public SAXBooks getKsiki()
    {
        return this.ksiki;
    }

    public void startElement( String uri,
                              String nazwa_lokalna,
                              String nazwa_kwalifikowana,
                              Attributes atrybuty )
    {
        System.out.println( "Znaleziony element: " + nazwa_kwalifikowana );
        if( nazwa_kwalifikowana.equalsIgnoreCase( "ksiki" ) )
        {
            ksiki = new SAXBooks();
        }
        else if( nazwa_kwalifikowana.equalsIgnoreCase( "ksika" ) )
        {
            SAXBook ksika = new SAXBook();
            for( int i=0; i<atrybuty.getLength(); i++ )
            {
                if( atrybuty.getQName( i ).equalsIgnoreCase( "kategoria" ) )
                {
                     ksika.setKategoria( atrybuty.getValue( i ) );
                }
            }
            ksiki.addKsika( ksika );
        }
        else if( nazwa_kwalifikowana.equalsIgnoreCase( "autor" ) )
        {
            this.readingAutor = true;
        }
        else if( nazwa_kwalifikowana.equalsIgnoreCase( "tytu" ) )
        {
            this.readingTytu = true;
        }
        else if( nazwa_kwalifikowana.equalsIgnoreCase( "cena" ) )
        {
            this.readingCena = true;
        }
        else
        {
            System.out.println( "Nieznany element: " + nazwa_kwalifikowana );
        }
    }

    public void startDocument() 
    {
        System.out.println( "Rozpoczte..." );
    }

    public void endDocument() 
    {
        System.out.println( "Zakoczone..." );
    }
    
    public void characters( char[] ch,
                            int start,
                            int dugo )
    {
String znaki = new String( ch, start, dugo).trim();
        if( znaki.length() == 0 )
        {
            return;
        }

        SAXBook ksika = ksiki.getOstatnia();
        if( readingAutor )
        {
            ksika.setAutor( znaki ); 
        }
        else if( readingTytu )
        {
            ksika.setTytu( znaki ); 
        }
        else if( readingCena )
        {
            ksika.setCena( Float.parseFloat( znaki ) );
        }
    }
                
    public void endElement( String uri,
                            String nazwa_lokalna,
                            String nazwa_kwalifikowana )
    {
        System.out.println( "Ostatni element: " + nazwa_kwalifikowana );
        if( nazwa_kwalifikowana.equalsIgnoreCase( "autor" ) )
        {
            this.readingAutor = false;
        }
        else if( nazwa_kwalifikowana.equalsIgnoreCase( "tytu" ) )
        {
            this.readingTytu = false;
        }
        else if( nazwa_kwalifikowana.equalsIgnoreCase( "cena" ) )
        {
            this.readingCena = false;
        }
    }
}
