import java.io.*;
import java.net.*;

public class SendSoap
{
    public static void main(String args[])
    {
        if (args.length < 2)
        {
            System.out.println("Prosz poda adres URL i nazw pliku");
            System.exit(0);
        }

        try
        {
            URL dest = new URL(args[0]);
            File inFile = new File(args[1]);

            URLConnection conn = dest.openConnection();

            conn.setDoOutput(true);

            conn.setRequestProperty("Content-type", "text/xml");
            conn.setRequestProperty("Content-length", ""+inFile.length());
            conn.setRequestProperty("SOAPAction", "\"\"");

            OutputStream out = conn.getOutputStream();
            FileInputStream in = new FileInputStream(inFile);

            byte[] buff = new byte[4096];

            int len;

            while ((len = in.read(buff)) > 0)
            {
                out.write(buff, 0, len);
            }

            InputStream response = conn.getInputStream();

            while ((len = response.read(buff)) > 0)
            {
                System.out.write(buff, 0, len);
            }
        }
        catch (Exception exc)
        {
            exc.printStackTrace();
        }
    }
}
