<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>


   <xsl:output method="html"/>

   <xsl:template match="/" >
      <html>
         <xsl:apply-templates />
      </html>
   </xsl:template>

   <xsl:template match="menu">
      <head>
         <title>
            <xsl:value-of select="nazwa" />
         </title>
      </head>

      <body>
         <h1>
         <xsl:value-of select="nazwa" /> : 
         <xsl:value-of select="fax" /> (FAX)
         </h1>

         <h4>
            <xsl:value-of select="zamówienie" />
         </h4>

         <hr />

         <xsl:apply-templates />
      </body>
   </xsl:template>

   <xsl:template match="kategoria">
      <h2 align="center">
         <xsl:value-of select="nazwa" />
      </h2>

      <table border="2" width="100%">
         <tr>
            <th width="10%">pozycja</th>

            <th width="10%">wegetariańskie</th>

            <th width="10%">pikantne</th>

            <th width="10%">nazwa</th>

            <th width="50%">opis</th>

            <th width="10%">cena</th>
         </tr>

         <xsl:apply-templates />
      </table>
   </xsl:template>

   <xsl:template match="danie">
      <tr>
         <td align="center">
            <xsl:value-of select="@pozycja" />
         </td>

         <td align="center">
            <xsl:choose>
               <xsl:when test="@wegetariańskie='true'">tak</xsl:when>

               <xsl:when test="@wegetariańskie='false'">nie</xsl:when>
            </xsl:choose>
         </td>

         <td align="center">
            <xsl:choose>
               <xsl:when test="@pikantne='true'">tak</xsl:when>

               <xsl:when test="@pikantne='false'">nie</xsl:when>
            </xsl:choose>
         </td>

         <td align="center">
            <xsl:value-of select="nazwa" />
         </td>

         <td align="left">
            <xsl:value-of select="opis" />
         </td>

         <td align="right"> 
         <xsl:value-of select="cena" /> PLN
         </td>
      </tr>
   </xsl:template>

   <xsl:template match="*" />
</xsl:stylesheet>
