package com.ibm.etools.webservice.rt.samples;

/**
 * <code>TemperatureConverter</code> is a JavaBean that
 * converts temperatures between Celsius and Fahrenheit.
 * It can be used to demonstrate Web Services.
 *
 * @author Arthur Ryman
 * @version 1.0
 */
public class TemperatureConverter {

	/** absolute zero in degrees Celsius */
	public static float ABSOLUTE_ZERO_CELSIUS = (float) -273.0;
 
/**
 * Converts temperatures from Fahrenheit to Celsius.
 *
 * @return				the Celsius temperature
 * @param fahrenheit	the Fahrenheit temperature to convert
 * @exception Exception	If the temperature is below absolute zero.
 */
public float convertFtoC(float fahrenheit) throws Exception {

	if (fahrenheit < ABSOLUTE_ZERO_FAHRENHEIT) {

		throw new Exception("Temperature is below absolute zero.");
	}

	float celsius = (fahrenheit - 32) * 5 / 9;

	return celsius;
}
   
/**
 * Converts temperatures from Celsius to Fahrenheit.
 *
 * @return				the Fahrenheit temperature
 * @parameter celsius	the Celsius temperature to convert
 * @exception Exception	If the temperature is below absolute zero.
 */
public float convertCtoF(float celsius) throws Exception {

	if (celsius < ABSOLUTE_ZERO_CELSIUS) {

		throw new Exception("Temperature is below absolute zero.");
	}

	float fahrenheit = celsius * 9 / 5 + 32;

	return fahrenheit;
}

	/** absolute zero in degrees Fahrenheit */
	public static float ABSOLUTE_ZERO_FAHRENHEIT = (float) -459.4;

/**
 * Returns absolute in degrees Celsius.
 *
 * @return the value of absolute on the Celsius scale
 */
public float absoluteZeroC() {
	
	return ABSOLUTE_ZERO_CELSIUS;
}

/**
 * Returns absolute zero in degrees Fahrenheit.
 *
 * @return	the value of absolute zero on the Fahrenheit scale
 */
public float absoluteZeroF() {
	
	return ABSOLUTE_ZERO_FAHRENHEIT;
}
}