package jwsunleashed.trading.ejb;

import java.rmi.*;
import javax.ejb.*;

public interface Trading extends EJBObject
{
    public TradeResult put(String stock, int shares, int price)
        throws RemoteException;
    public TradeResult buy(String stock, int shares, int price)
        throws RemoteException;

    public TradeResult retractPut(int putID)
        throws RemoteException;
    public TradeResult retractBuy(int buyID)
        throws RemoteException;

    public TradeResult getPutStatus(int putID)
        throws RemoteException;
    public TradeResult getBuyStatus(int buyID)
        throws RemoteException;

    public TradeResult[] getOutstandingPuts()
        throws RemoteException;
    public TradeResult[] getOutstandingBuys()
        throws RemoteException;
}
