package jwsunleashed.trading.ejb;

import java.rmi.*;
import java.util.*;
import javax.ejb.*;
import java.sql.*;
import javax.sql.*;
import javax.naming.*;
import java.util.Date;

public abstract class TraderImpl extends AutoKeyEJB
{
/** An EJB must have a public, parameterless constructor */

    public TraderImpl()
    {
    }

    public String getKeyDatabaseName() { return "TradingDB"; }
    public String getKeyTableName() { return "TRADER_ID_SEQ"; }
    public String getKeyColumnName() { return "TRADER_ID"; }

/** Called by the EJB container when a client calls the create() method in
    the home interface */

    public Integer ejbCreate()
        throws CreateException
    {
        try
        {
// compute the new primary key for this object
            setTraderId(getNextId());

            return null;
        }
        catch (SQLException exc)
        {
            throw new CreateException(
                "Unable to access database: "+exc.toString());
        }
    }

// Implement the get/set methods for all the data elements

    public abstract int getTraderId();
    public abstract void setTraderId(int aTraderId);

    public abstract String getUserID();
    public abstract void setUserID(String aUserID);

    public abstract String getPassword();
    public abstract void setPassword(String aPassword);

    public abstract String getDescription();
    public abstract void setDescription(String aDescription);
}
