package jwsunleashed.trading.ejb;

import java.rmi.*;
import java.util.*;
import javax.ejb.*;
import java.sql.*;
import javax.sql.*;
import javax.naming.*;
import java.util.Date;

public abstract class TradeImpl extends AutoKeyEJB
{
/** An EJB must have a public, parameterless constructor */

    public TradeImpl()
    {
    }

    public String getKeyDatabaseName() { return "TradingDB"; }
    public String getKeyTableName() { return "TRADE_ID_SEQ"; }
    public String getKeyColumnName() { return "TRADE_ID"; }

/** Called by the EJB container when a client calls the create() method in
    the home interface */

    public Integer ejbCreate()
        throws CreateException
    {
        try
        {
// compute the new primary key for this object
            setTradeId(getNextId());

            return null;
        }
        catch (SQLException exc)
        {
            throw new CreateException(
                "Unable to access database: "+exc.toString());
        }
    }

// Implement the get/set methods for all the data elements

    public abstract int getTradeId();
    public abstract void setTradeId(int aTradeId);

    public abstract int getSellerID();
    public abstract void setSellerID(int aSellerID);

    public abstract int getBuyerID();
    public abstract void setBuyerID(int aBuyerID);

    public abstract int getPutID();
    public abstract void setPutID(int aPutID);

    public abstract int getBuyID();
    public abstract void setBuyID(int aBuyID);

    public abstract String getStock();
    public abstract void setStock(String aStock);

    public abstract int getShares();
    public abstract void setShares(int numShares);

    public abstract int getPrice();
    public abstract void setPrice(int thePrice);

    public abstract Date getTransTime();
    public abstract void setTransTime(Date aTransTime);
}
