package localhost_8080.wsif.TimeServer;

import java.util.*;
import javax.wsdl.*;
import com.ibm.wsdl.xml.*;
import com.ibm.wsif.*;
import com.ibm.wsif.stub.*;

/**
 * Demonstracja lokalizacji konstruktora portu w czasie dziaania aplikacji
 * za pomoc rejestru JNDI. Jeeli poszukiwanie w JNDI nie powiedzie si.
 * do inicjalizacji dynamicznego konstruktora portu jest wykorzystywany dokument WSDL.
 * Nastpnie na podstawie konstruktora jest okrelany waciwy port,
 * z ktrego skorzysta ten pniak.
 */
public class TimeServicePortTypeStub extends WSIFStub
  implements TimeServicePortType
{
  private final String DOCUMENT_BASE =
    "http://localhost:8080/wsif/TimeServerSOAPAndJavaPort.wsdl";
  private final String PORT_TYPE_NS =
    "http://localhost:8080/wsif/TimeServer-interface";
  private final String PORT_TYPE_NAME = "TimeServicePortType";

  /**
   * Utworzenie nowego pniaka za pomoc konstruktora otrzymanego za porednictwem JNDI.
   * Jeeli operacja ta si nie powiedzie, dynamiczny konstruktor portu inicjalizowany
   * jest na podstawie wskazanego dokumentu WSDL. Jeeli parametry serviceNS 
   * i serviceName nie s rwne null, zostan wykorzystane przy wyborze usugi.
   */
  public TimeServicePortTypeStub(String serviceNS, String serviceName) 
    throws WSIFException
  {
    locatePortFactory(
      null,
      DOCUMENT_BASE,
      WSDL_DEFINITION_STR,
      serviceNS,
      serviceName,
      PORT_TYPE_NS,
      PORT_TYPE_NAME);
  }

  public long synchronizeTime() throws WSIFException
  {
    WSIFMessage input = wp.createInputMessage();


    WSIFMessage output = wp.createOutputMessage();

    wp.executeRequestResponseOperation("synchronizeTime", 
      input, output, null);

    WSIFPart part = output.getPart("return");

    return ((Long)part.getJavaValue()).longValue();
  }

  public String getTimeAtCity(String zoneName) throws WSIFException
  {
    WSIFMessage input = wp.createInputMessage();

    input.setPart("zoneName", new WSIFJavaPart(String.class, zoneName));

    WSIFMessage output = wp.createOutputMessage();

    wp.executeRequestResponseOperation("getTimeAtCity", 
      input, output, null);

    WSIFPart part = output.getPart("return");

    return (String)part.getJavaValue();
  }

  private static final String WSDL_DEFINITION_STR =
    "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + "\r\n" +
    "<definitions name=\"TimeService\" targetNamespace=\"http://localhost:8080/wsif/TimeServer\" xmlns:xsd=\"http://www.w3.org/1999/XMLSchema\" xmlns:tns=\"http://localhost:8080/wsif/TimeServer\" xmlns:java=\"http://schemas.xmlsoap.org/wsdl/java/\" xmlns:tns-inter=\"http://localhost:8080/wsif/TimeServer-interface\" xmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\" xmlns=\"http://schemas.xmlsoap.org/wsdl/\">" + "\r\n" +
    "  <import namespace=\"http://localhost:8080/wsif/TimeServer-interface\" location=\"http://localhost:8080/wsif/TimeServer-interface.wsdl\"/>" + "\r\n" +
    "  <binding name=\"TimeServiceJavaBinding\" type=\"tns-inter:TimeServicePortType\">" + "\r\n" +
    "      <java:binding/>" + "\r\n" +
    "  </binding>" + "\r\n" +
    "  <binding name=\"TimeServiceSOAPBinding\" type=\"tns-inter:TimeServicePortType\">" + "\r\n" +
    "    <soap:binding style=\"rpc\" transport=\"http://schemas.xmlsoap.org/soap/http\"/>" + "\r\n" +
    "    <operation name=\"synchronizeTime\">" + "\r\n" +
    "      <soap:operation soapAction=\"\"/>" + "\r\n" +
    "      <input>" + "\r\n" +
    "        <soap:body use=\"encoded\" encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" namespace=\"urn:TimeServer\"/>" + "\r\n" +
    "      </input>" + "\r\n" +
    "      <output>" + "\r\n" +
    "        <soap:body use=\"encoded\" encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" namespace=\"urn:TimeServer\"/>" + "\r\n" +
    "      </output>" + "\r\n" +
    "    </operation>" + "\r\n" +
    "    <operation name=\"getTimeAtCity\">" + "\r\n" +
    "      <soap:operation soapAction=\"\"/>" + "\r\n" +
    "      <input>" + "\r\n" +
    "        <soap:body use=\"encoded\" encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" namespace=\"urn:TimeServer\"/>" + "\r\n" +
    "      </input>" + "\r\n" +
    "      <output>" + "\r\n" +
    "        <soap:body use=\"encoded\" encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" namespace=\"urn:TimeServer\"/>" + "\r\n" +
    "      </output>" + "\r\n" +
    "    </operation>" + "\r\n" +
    "  </binding>" + "\r\n" +
    "  <service name=\"TimeService\">" + "\r\n" +
    "<documentation>" + "\r\n" +
    "   Centralny serwer synchronizacji czasu.+ "\r\n" +
    "   Udostpnia biecy czas GMT w milisekundach od pocztku epoki lub" + "\r\n" +
    " biecy czas dla okrelonej strefy czasowej w odniesieniu do czasu lokalnego" + "\r\n" +
    " serwera.. " + "\r\n" +
    "            </documentation>" + "\r\n" +
    "    <port name=\"TimeServiceJavaPort\" binding=\"tns:TimeServiceJavaBinding\">" + "\r\n" +
    "      <java:address class=\"TimeServer\"/>" + "\r\n" +
    "    </port>" + "\r\n" +
    "    <port name=\"TimeServiceSOAPPort\" binding=\"tns:TimeServiceSOAPBinding\">" + "\r\n" +
    "      <soap:address location=\"http://localhost:8080/soap/servlet/rpcrouter\"/>" + "\r\n" +
    "    </port>" + "\r\n" +
    "  </service>" + "\r\n" +
    "</definitions>";
}
