package localhost_8080.wsif.TimeServer;
/**
 * Testowanie portw dla aplikacji TimeServer za pomoc wygenerowanych klas pniakw.
 */

import localhost_8080.wsif.TimeServer.*;

public class StubTimeServerClient {

    public static final String DEFAULT_PORT = "TimeServiceSOAPPort";
    public static final String DEFAULT_TIME_ZONE = "Africa/Nairobi";

    public static void main(String[] args) {

        String portName = null;
        String timeZone = null;
        if (args.length == 0) {
            // Default port
            portName = DEFAULT_PORT;
            timeZone = DEFAULT_TIME_ZONE;
        } else if (args.length == 1) {
            portName = args[0];
            timeZone = DEFAULT_TIME_ZONE;
        } else if (args.length == 2) {
            portName = args[0];
            timeZone = args[1];
        } else {
            String className = StubTimeServerClient.class.getName();
            System.err.println("Skdnia: java " + className + " [portName] [timeZone]");
            System.err.println(
                "Np: java "
                    + className
                    + " TimeServiceSOAPPort \t- Sprawdza zarwno metod synchronizeTime() jak i getTimeAtCity() za pomoc portu SOAP");
            System.err.println("Domylnym portem jest " + DEFAULT_PORT);
            System.err.println("Domyln stref czasow jest " + DEFAULT_TIME_ZONE);
            System.exit(0);
        }

        try {
            TimeServicePortTypeStub timeSvcPortTypeStub =
                new TimeServicePortTypeStub(null, null);
            timeSvcPortTypeStub.selectPort(portName);
            System.out.println(
                "Wynik dziaania portu "
                    + portName
                    + " wywoujcego synchronizeTime()="
                    + timeSvcPortTypeStub.synchronizeTime());
            System.out.println(
                "Wynik dziaania portu "
                    + portName
                    + " wywoujcego getTimeAtCity(\""
                    + timeZone
                    + "\")="
                    + timeSvcPortTypeStub.getTimeAtCity(timeZone));

        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
