/** Klasa pomocnicza do konwersji w obu kierunkach midzy tekstem a Base64 */
 
public class Base64
{
   
/** Znaki reprezentujce kady 6-bitowy wzorzec w Base 64 */
    public static final String base64Chars =
        "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

/** Konwersja tablicy bajtowej do cigu znakw Base 64. */
    public static String toBase64(byte[] bytes)
    {
        StringBuffer outBuff = new StringBuffer();

// Ptla przebiegajca przez cig znakw i pobierajca 3 w kadym kroku
        for (int i=0; i < bytes.length; i += 3)
        {
// Przechowanie 3 8-bitowych znakw, ktre zostan konwertowane do postaci 4 znakw 6-bitowych
            int packed64 = 0;

// Zakadamy, e kadorazowo wyprowadzane s 4 pene znaki. Na kocu
// cigu brakujce znaki zostan wypenione symbolem =
            int num64Chars = 4;
            
// Pobranie pierwszego znaku i umieszczenie w pakujcej zmiennej cakowitoliczbowej
            packed64 = bytes[i] << 16;

// Dodanie do bufora innego znaku, jeeli zostanie odnaleziony
            if (i+1 < bytes.length)
            {
                packed64 = packed64 + (bytes[i+1] << 8);
            }
            else
            {
// W przeciwnym przypadku wyprowadzone zostan 2 znaki wypeniajce. Spord 4 znakw 6-bitowych,
// do przedstawienia liczby omiobitowej niezbdne s dwa.
                num64Chars = 2;
            }

// Dodanie do bufora kolejnego znaku, o ile wystpuje.
            if (i + 2 < bytes.length)
            {
                packed64 = packed64 + bytes[i+2];
            }
// W przeciwnym przypadku, jeeli oczekiwano wyprowadzenia 4 znakw 6-bitowych,
// wyprowadzone zostay jedynie 3. Do tego punktu mona dotrze
// po ustawieniu liczby znakw na 2, wic naley si upewni, e przypadkowo
// nie zostanie zapisanych wicej znakw ni potrzeba.
            else if (num64Chars == 4)
            {
                num64Chars = 3;
            }

// Ptla przebiegajca przez zmienn poredniczc i pobierajca 6 bits jednoczenie. Wyprowadzanie
// znaku w formie cigu base64Chars odpowiadajcego kadej wartoci
// 6-bitowej.
            for (int j=0; j < num64Chars; j++)
            {
                outBuff.append(base64Chars.charAt(
                    (packed64 >> (6 * (3-j))) & 63));
            }

// Jeeli zapisano mniej ni 4 wartoci 6-bitowe, wyprowadzane s znaki wypeniajce
            for (int j=num64Chars; j < 4; j++)
            {
                outBuff.append('=');
            }
        }

// Zwrot cigu Base64
        return outBuff.toString();
    }

/** Konwersja cigu base64 do postaci zwykego cigu znakw */
    public static String fromBase64(String str)
    {

// TWorzenie bufora do przechowania zwykego cigu znakw.
        StringBuffer outBuff = new StringBuffer();

// Konwersja cigu znakw base64 do postaci tablicy bajtowej
        byte[] stringBytes = str.getBytes();

// Ptla analizujca grup bajtw w porcjach po 4.
        for (int i=0; i < stringBytes.length; i += 4)
        {
            int currWord = 0;

// Zaoenie, e ten zbir bajtw zawiera 3 pene znaki.
            int charsInWord = 3;

            for (int j=0; j < 4; j++)
            {
                byte ch = stringBytes[i+j];

// Natrafienie na znak wypenienia oznacza, e w tym zbiorze 4 bajtw zakodowanych jest mniej
// ni 3 znaki. Jak si okae, liczba zakodowanych znakw
// odpowiada pozycji, gdzie po raz pierwszy wystpi znak '='
                if (ch == '=')
                {
                    charsInWord = j;
                    break;
                }

// Pobranie wartoci 6-bitowej odpowiadajcej temu znakowi.
                ch = (byte) base64Chars.indexOf(ch);

// Dodanie wartoci 6-bitowych do zmiennej poredniczcej (warto 24-bitowa tworzona jest
// z 4 wartoci 6-bitowych)
                currWord = currWord + (ch << (6 * (3 - j)));
            }

// Pobieranie znakw z poredniczcej zmiennej cakowitoliczbowej w porcjach 
// po 8 bitw.
            for (int j=0; j < charsInWord; j++)
            {
                outBuff.append((char) ((currWord >> (8 * (2-j))) & 255));
            }
        }

// Zwrot odkodowanego cigu znakw.
        return outBuff.toString();
    }

/** Program testowy sprawdzajcy poprawno dziaania procedury kodujcej. Koduje
    kady argument z wiersza polece do postaci base64 i z powrotem.
*/
    public static void main(String args[])
    {
        for (int i=0; i < args.length; i++)
        {
            String base64 = toBase64(args[i].getBytes());
            String un64 = fromBase64(base64);

            System.out.println(args[i]+" -> "+base64+" -> "+un64);
        }
    }
}
