package com.sams.jws.chapter15;
/*
 * HelloWorldReceiver
 * Odbiera komunikat JAXM i wysya odpowied w rozsdnym czasie.
 */

// Oglne JDK
import java.io.IOException;
// JAXM
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPPart;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPException;
import javax.xml.messaging.JAXMServlet;
import javax.xml.messaging.ReqRespListener;
// Serwlet
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

public class HelloWorldReceiver
    extends JAXMServlet
    implements ReqRespListener {
    MessageFactory messageFactory = null;
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        try {
            messageFactory = MessageFactory.newInstance();
        } catch (SOAPException e) {
            System.err.println("Podczas tworzenia instancji MessageFactory wystpi bd:");
            e.printStackTrace();
        } // Catch
    }
    public SOAPMessage onMessage(SOAPMessage requestSoapMsg) {
        System.out.println(
            "HelloWorldReceiver odebra w onMessage() nastpujcy komunikat JAXM:");
        try {
            requestSoapMsg.writeTo(System.out);
            System.out.println("\n");

            SOAPMessage responseSoapMsg = messageFactory.createMessage();

            /*
             * Warto zauway, e nie zosta zdefiniowany element nagwka. 
             * Chocia jest to element nieobowizkowy, JAXM 
             * niejawnie utworzy pusty nagwek.
             */
            // Tworzenie elementu ciaa zawierajcego odpowied.
            SOAPEnvelope responseSoapEnv = responseSoapMsg.getSOAPPart()
                                                          .getEnvelope();
            SOAPBody responseSoapBody = responseSoapEnv.getBody();
            SOAPBodyElement responseSoapBodyEl =
                responseSoapBody.addBodyElement(responseSoapEnv.createName("Response"));
            responseSoapBodyEl.addTextNode("Witaj!!!");

            responseSoapMsg.saveChanges();
            System.out.println(
                "HelloWorldReceiver odpowiada za pomoc nastpujcego komunikatu JAXM:");
            responseSoapMsg.writeTo(System.out);
            System.out.println("\n");

            return responseSoapMsg;

        } catch (SOAPException e) {
            System.err.println("Podczas przetwarzania lub wysyania odpowiedzi na komunikat wystpi bd");
            e.printStackTrace();
            return null;
        } catch (IOException e) {
            System.err.println(
                "Podczas zapisu SOAPMessage do System.out wystpi wyjtek IOException: ");
            e.printStackTrace();
            return null;
        }
    } // onMessage()
} // HelloWorldReceiver
