package com.sams.jws.chapter15;
/**
 * FileRetrieverServlet
 * Serwlet demonstrujcy wykorzystanie JAXM. Wywouje zdaln usug sieciow
 * obsugi plikw, a nastpnie przetwarza wynik do postaci
 * czytelnej dla przegldarki.
 */
// Oglne JDK
import java.io.IOException;
import java.util.Iterator;
// JAXM
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPPart;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import javax.xml.soap.AttachmentPart;
import javax.xml.messaging.URLEndpoint;
// JAF
import javax.activation.DataHandler;
// Serwlet
import javax.servlet.*;
import javax.servlet.http.*;

public class FileRetrieverServlet extends HttpServlet {
    private final static boolean DEBUG = true;
    private final static String FILE_SERVICE_URL =
        "http://localhost:8080/jaxm/servlet/com.sams.jws.chapter15.FileService";
    public URLEndpoint urlEndpoint = new URLEndpoint(FILE_SERVICE_URL);
    private final static String DEFAULT_TARGET = "/";
    public SOAPConnection soapConnection = null;
    /**
     * doGet()
     * Odpowiada na otrzymane z przegldarki danie pobrania listy plikw z 
     * FileService.
     * Obsuguje we waciwy sposb otrzymane wyniki, przekazujc plik bezporednio do ]
     * przegldarki, zwracajc list plikw w katalogu lub zwracajc stron bdu z 
     * wyjanieniem, gdzie wystpi bd. Odpowiedni plik znajduje si w polu FileName 
     * acucha dania.
     */
    public void doGet(
        HttpServletRequest httpServletRequest,
        HttpServletResponse httpServletResponse)
        throws ServletException {

        ServletOutputStream outputStream = null;
        try {
            outputStream = httpServletResponse.getOutputStream();

            String targetFile = httpServletRequest.getParameter("FileName");
            if ((targetFile == null) || (targetFile == ""))
                targetFile = DEFAULT_TARGET;

            if (DEBUG)
                System.out.println(
                    "FileRetrieverServlet otrzyma dania pobrania pliku: " + targetFile);

            // Przesanie dania pobrania pliku do usugi FileService.
            SOAPMessage responseSoapMsg = sendRequestMsg(targetFile);

            // Pobranie kilku pomocniczych odwoa do komunikatu odpowiedzi.
            SOAPEnvelope responseSoapEnv = responseSoapMsg.getSOAPPart().getEnvelope();
            SOAPHeader responseSoapHdr = responseSoapEnv.getHeader();
            SOAPBody responseSoapBody = responseSoapEnv.getBody();

            // Okrelenie typu odpowiedzi i waciwa jej obsuga.
            String responseType =
                DocumentUtils.findValueOfChild(responseSoapHdr, "ResponseType");
            if ((responseType != null) && (responseType.equals("directoryListing"))) {
                // Zwrot odpowiedzi do przegldarki w niezmienionej postaci. Mona 
                // take.w tym miejscu zbudowa dokument HTML zawierajcy spis pozycji 
                // katalogu z odpowiednim odsyaczem do kadego pliku.
                httpServletResponse.setContentType("text/xml");
                responseSoapMsg.writeTo(outputStream);
            } else if (responseType.equals("attachedFile")) {
                // Zwrot zacznika.
                Iterator iterator = responseSoapMsg.getAttachments();
                if (iterator.hasNext()) {
                    // Zakdamy, e pierwsza cz zacznika jest poszukiwanym 
                    // plikiem. 
                    // Lepszym rozwizaniem jest poszukanie odpowiedniego nagwka MIME.
                    AttachmentPart attachmentPart = (AttachmentPart) iterator.next();
                    DataHandler dataHandler = attachmentPart.getDataHandler();
                    httpServletResponse.setContentType(dataHandler.getContentType());
                    dataHandler.writeTo(outputStream);
                } else {
                    renderErrorPage(outputStream, "Nie udao si zlokalizowa zaczonego pliku", targetFile);
                } // Else
            } else if (responseType.equals("fault")) {
                SOAPFault soapFault = responseSoapBody.getFault();
                httpServletResponse.setContentType("text/html");
                renderErrorPage(
                    outputStream,
                    "<B>Code:</B> " + soapFault.getFaultCode(),
                    "<B>Description:</B> " + soapFault.getFaultString());
            } else {
                // Nieznana odpowied
                httpServletResponse.setContentType("text/html");
                renderErrorPage(
                    outputStream,
                    "Serwer zwrci uszkodzony komunikat odpowiedzi.",
                    "<B>Pobieranie pliku nie powiodo si:</B> " + targetFile);
            } 
            // Oglne wyjtki obsugi SOAPMessage.
        } catch (SOAPException e) {
            System.err.println("Wystpi oglny wyjtek SOAPException: ");
            e.printStackTrace();
        } catch (IOException e) {
            System.err.println(
                "Wystpi wyjtek IOException podczas prby zapisu do SOAPMessage: ");
            e.printStackTrace();
        } 
    } // doGet()
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        try {
            // Inicjalizacja poczenia do wykorzystania przez wszystkie instancje.
            SOAPConnectionFactory soapConnFct = SOAPConnectionFactory.newInstance();
            soapConnection = soapConnFct.createConnection();
        } catch (SOAPException e) {
            System.err.println("Wystpi oglny wyjtek SOAPException: ");
            e.printStackTrace();
        }
    } // init()
    /**
     * renderErrorPage
     * Zwrot bdu w sformatowanym dokumencie HTML do strumienia ServletOutputStream
     */
    public void renderErrorPage(
        ServletOutputStream outputStream,
        String line1,
        String line2)
        throws IOException {
        outputStream.println("<HTML>");
        outputStream.println("Podczas obsugi dania wystpi bd.<P>");
        outputStream.println(line1 + "<P>");
        outputStream.println(line2 + "<P>");
        outputStream.println("</HTML>");
    } // renderErrorPage()
    /**
     * sendRequestMsg
     * Wywoanie usugi sieciowej zdalnego dostpu do plikw FileService i danie
     * pobrania pliku targetFile. Zwrot odpowiedzi SOAPMessage.
     */
    public SOAPMessage sendRequestMsg(String targetFile)
        throws SOAPException, IOException {

        // Inicjalizacja poczenia i profilu SOAP
        MessageFactory messageFactory = MessageFactory.newInstance();

        SOAPMessage requestSoapMsg = messageFactory.createMessage();

        SOAPPart requestSoapPart = requestSoapMsg.getSOAPPart();
        SOAPEnvelope requestSoapEnv = requestSoapPart.getEnvelope();
        SOAPHeader requestSoapHdr = requestSoapEnv.getHeader();
        SOAPBody requestSoapBody = requestSoapEnv.getBody();

        // Doczenie pola nagwka
        Name msgPurposeName = requestSoapEnv.createName("CmdName");
        SOAPHeaderElement msgPurposeElement =
            requestSoapHdr.addHeaderElement(msgPurposeName);
        msgPurposeElement.setMustUnderstand(true);
        msgPurposeElement.addTextNode("FileService");

        // Doczenie pola ciaa kwalifikowanego za pomoc przestrzeni nazw
        Name fileName = requestSoapEnv.createName("FileName");
        SOAPBodyElement fileNameElement = requestSoapBody.addBodyElement(fileName);
        fileNameElement.addTextNode(targetFile);

        // Zapis wszystkich zmian w komunikacie przed jego wywietleniem. 
        // Wysanie take niejawnie zapisze dokonane zmiany.
        requestSoapMsg.saveChanges();

        if (DEBUG) {
            System.out.println("FileRetrieverServlet wysya komunikat:");
            requestSoapMsg.writeTo(System.out);
            System.out.println("\n");
        } 

        // Wysanie dania i zablokowanie aplikacji do momentu otrzymania odpowiedzi.
        SOAPMessage responseSoapMsg = soapConnection.call(requestSoapMsg, urlEndpoint);

        if (DEBUG) {
            System.out.println("FileRetrieverServlet otrzyma komunikat odpowiedzi:");
            responseSoapMsg.writeTo(System.out);
            System.out.println("\n");
        } 

        return responseSoapMsg;

    } // sendRequestMsg()
} // FileRetrieverServlet
