/*
 * Decompiled with CFR 0.152.
 */
package jwsunleashed.trading.ejb;

import java.io.Serializable;

public class TradeResult
implements Serializable {
    public static final int PUT = 1;
    public static final int BUY = 2;
    public static final String[] TRADE_TYPES = new String[]{"", "PUT", "BUY"};
    public static final int TRADE_COMPLETED = 1;
    public static final int TRADE_PENDING = 2;
    public static final int TRADE_RETRACTED = 3;
    public static final int NO_PUT_FOUND = 4;
    public static final int NO_BUY_FOUND = 5;
    public static final String[] STATUSES = new String[]{"", "TRADE COMPLETED", "TRADE PENDING", "TRADE RETRACTED", "NO PUT FOUND", "NO BUY FOUND"};
    public int status;
    public int tradeID;
    public int sellerID;
    public int buyerID;
    public int putID;
    public int buyID;
    public int tradeType;
    public String stock;
    public int price;
    public int shares;

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public int getTradeID() {
        return this.tradeID;
    }

    public void setTradeID(int n) {
        this.tradeID = n;
    }

    public int getSellerID() {
        return this.sellerID;
    }

    public void setSellerID(int n) {
        this.sellerID = n;
    }

    public int getBuyerID() {
        return this.buyerID;
    }

    public void setBuyerID(int n) {
        this.buyerID = n;
    }

    public int getBuyID() {
        return this.buyID;
    }

    public void setBuyID(int n) {
        this.buyID = n;
    }

    public int getPutID() {
        return this.putID;
    }

    public void setPutID(int n) {
        this.putID = n;
    }

    public int getTradeType() {
        return this.tradeType;
    }

    public void setTradeType(int n) {
        this.tradeType = n;
    }

    public String getStock() {
        return this.stock;
    }

    public void setStock(String string) {
        this.stock = string;
    }

    public int getPrice() {
        return this.price;
    }

    public void setPrice(int n) {
        this.price = n;
    }

    public int getShares() {
        return this.shares;
    }

    public void setShares(int n) {
        this.shares = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Status: ");
        stringBuffer.append(STATUSES[this.status]);
        if (this.tradeID > 0) {
            stringBuffer.append(", Trade: ");
            stringBuffer.append(this.tradeID);
        }
        if (this.buyerID > 0) {
            stringBuffer.append(", Buyer: ");
            stringBuffer.append(this.buyerID);
        }
        if (this.sellerID > 0) {
            stringBuffer.append(", Seller: ");
            stringBuffer.append(this.sellerID);
        }
        if (this.buyID > 0) {
            stringBuffer.append(", Buy: ");
            stringBuffer.append(this.buyID);
        }
        if (this.putID > 0) {
            stringBuffer.append(", Put: ");
            stringBuffer.append(this.putID);
        }
        if (this.tradeType > 0) {
            stringBuffer.append(", Trade Type: ");
            stringBuffer.append(TRADE_TYPES[this.tradeType]);
        }
        if (this.stock != null) {
            stringBuffer.append(", Stock: ");
            stringBuffer.append(this.stock);
            stringBuffer.append(", Shares: ");
            stringBuffer.append(this.shares);
            stringBuffer.append(", Price: ");
            stringBuffer.append(this.price);
        }
        return stringBuffer.toString();
    }
}

