/*
 * Decompiled with CFR 0.152.
 */
package jwsunleashed.trading;

import java.math.BigInteger;
import java.rmi.RemoteException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Hashtable;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import jwsunleashed.trading.TradingException;
import jwsunleashed.trading.ejb.TradeResult;
import jwsunleashed.trading.ejb.Trading;
import jwsunleashed.trading.ejb.TradingHome;

public class StockTrading {
    protected static Hashtable users = new Hashtable();
    protected SecureRandom random;
    static /* synthetic */ Class class$jwsunleashed$trading$ejb$TradingHome;

    public StockTrading() {
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
    }

    public String login(String string, String string2) throws TradingException {
        try {
            InitialContext initialContext = new InitialContext();
            TradingHome tradingHome = (TradingHome)PortableRemoteObject.narrow((Object)initialContext.lookup("ejb/TradingHome"), (Class)(class$jwsunleashed$trading$ejb$TradingHome == null ? (class$jwsunleashed$trading$ejb$TradingHome = StockTrading.class$("jwsunleashed.trading.ejb.TradingHome")) : class$jwsunleashed$trading$ejb$TradingHome));
            Trading trading = tradingHome.create(string, string2);
            byte[] byArray = new byte[16];
            this.random.nextBytes(byArray);
            String string3 = new BigInteger(byArray).toString(16);
            users.put(string3, trading);
            return string3;
        }
        catch (NamingException namingException) {
            namingException.printStackTrace();
            throw new TradingException(namingException.toString());
        }
        catch (CreateException createException) {
            createException.printStackTrace();
            throw new TradingException(createException.toString());
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            throw new TradingException(remoteException.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new TradingException(exception.toString());
        }
    }

    public TradeResult put(String string, String string2, int n, int n2) throws TradingException {
        Trading trading = this.getTradingSession(string);
        try {
            TradeResult tradeResult = trading.put(string2, n, n2);
            System.out.println("Got result: " + tradeResult);
            return tradeResult;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            throw new TradingException(remoteException.toString());
        }
    }

    public TradeResult buy(String string, String string2, int n, int n2) throws TradingException {
        Trading trading = this.getTradingSession(string);
        try {
            TradeResult tradeResult = trading.buy(string2, n, n2);
            System.out.println("Got result: " + tradeResult);
            return tradeResult;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            throw new TradingException(remoteException.toString());
        }
    }

    public TradeResult retractPut(String string, int n) throws TradingException {
        Trading trading = this.getTradingSession(string);
        try {
            return trading.retractPut(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            throw new TradingException(remoteException.toString());
        }
    }

    public TradeResult retractBuy(String string, int n) throws TradingException {
        Trading trading = this.getTradingSession(string);
        try {
            return trading.retractBuy(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            throw new TradingException(remoteException.toString());
        }
    }

    public TradeResult getPutStatus(String string, int n) throws TradingException {
        Trading trading = this.getTradingSession(string);
        try {
            return trading.getPutStatus(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            throw new TradingException(remoteException.toString());
        }
    }

    public TradeResult getBuyStatus(String string, int n) throws TradingException {
        Trading trading = this.getTradingSession(string);
        try {
            return trading.getBuyStatus(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            throw new TradingException(remoteException.toString());
        }
    }

    public TradeResult[] getOutstandingPuts(String string) throws TradingException {
        Trading trading = this.getTradingSession(string);
        try {
            return trading.getOutstandingPuts();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            throw new TradingException(remoteException.toString());
        }
    }

    public TradeResult[] getOutstandingBuys(String string) throws TradingException {
        Trading trading = this.getTradingSession(string);
        try {
            return trading.getOutstandingBuys();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            throw new TradingException(remoteException.toString());
        }
    }

    public void logout(String string) throws TradingException {
        if (users.remove(string) != null) {
            return;
        }
        throw new TradingException("ID " + string + " is not logged in");
    }

    protected Trading getTradingSession(String string) throws TradingException {
        Trading trading = (Trading)users.get(string);
        if (trading != null) {
            return trading;
        }
        throw new TradingException("ID " + string + " is not logged in");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

