/*
 * Decompiled with CFR 0.152.
 */
package jwsunleashed.trading.ejb;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import jwsunleashed.trading.ejb.BuyOrder;
import jwsunleashed.trading.ejb.BuyOrderHome;
import jwsunleashed.trading.ejb.PutOrder;
import jwsunleashed.trading.ejb.PutOrderHome;
import jwsunleashed.trading.ejb.Trade;
import jwsunleashed.trading.ejb.TradeHome;
import jwsunleashed.trading.ejb.TradeResult;
import jwsunleashed.trading.ejb.Trader;
import jwsunleashed.trading.ejb.TraderHome;

public class TradingImpl
implements SessionBean {
    protected TradeHome tradeHome;
    protected TraderHome traderHome;
    protected BuyOrderHome buyOrderHome;
    protected PutOrderHome putOrderHome;
    protected int currTraderID;
    private SessionContext context;
    static /* synthetic */ Class class$jwsunleashed$trading$ejb$TradeHome;
    static /* synthetic */ Class class$jwsunleashed$trading$ejb$TraderHome;
    static /* synthetic */ Class class$jwsunleashed$trading$ejb$PutOrderHome;
    static /* synthetic */ Class class$jwsunleashed$trading$ejb$BuyOrderHome;
    static /* synthetic */ Class class$jwsunleashed$trading$ejb$BuyOrder;
    static /* synthetic */ Class class$jwsunleashed$trading$ejb$PutOrder;

    public void ejbCreate(String string, String string2) throws RemoteException, CreateException {
        try {
            InitialContext initialContext = new InitialContext();
            this.tradeHome = (TradeHome)PortableRemoteObject.narrow((Object)initialContext.lookup("java:com/env/ejb/TradeHome"), (Class)(class$jwsunleashed$trading$ejb$TradeHome == null ? (class$jwsunleashed$trading$ejb$TradeHome = TradingImpl.class$("jwsunleashed.trading.ejb.TradeHome")) : class$jwsunleashed$trading$ejb$TradeHome));
            this.traderHome = (TraderHome)PortableRemoteObject.narrow((Object)initialContext.lookup("java:com/env/ejb/TraderHome"), (Class)(class$jwsunleashed$trading$ejb$TraderHome == null ? (class$jwsunleashed$trading$ejb$TraderHome = TradingImpl.class$("jwsunleashed.trading.ejb.TraderHome")) : class$jwsunleashed$trading$ejb$TraderHome));
            this.putOrderHome = (PutOrderHome)PortableRemoteObject.narrow((Object)initialContext.lookup("java:com/env/ejb/PutOrderHome"), (Class)(class$jwsunleashed$trading$ejb$PutOrderHome == null ? (class$jwsunleashed$trading$ejb$PutOrderHome = TradingImpl.class$("jwsunleashed.trading.ejb.PutOrderHome")) : class$jwsunleashed$trading$ejb$PutOrderHome));
            this.buyOrderHome = (BuyOrderHome)PortableRemoteObject.narrow((Object)initialContext.lookup("java:com/env/ejb/BuyOrderHome"), (Class)(class$jwsunleashed$trading$ejb$BuyOrderHome == null ? (class$jwsunleashed$trading$ejb$BuyOrderHome = TradingImpl.class$("jwsunleashed.trading.ejb.BuyOrderHome")) : class$jwsunleashed$trading$ejb$BuyOrderHome));
            Trader trader = this.traderHome.findByUserID(string);
            if (trader == null) {
                throw new CreateException("Invalid User ID");
            }
            String string3 = trader.getPassword();
            if (string2 == null || string3 == null || !string2.equals(string3)) {
                throw new CreateException("Invalid password");
            }
            Integer n = (Integer)trader.getPrimaryKey();
            this.currTraderID = n;
        }
        catch (NamingException namingException) {
            throw new CreateException("Unable to create trading session: " + namingException.toString());
        }
        catch (FinderException finderException) {
            throw new CreateException("Invalid User ID");
        }
        catch (EJBException eJBException) {
            throw new CreateException("Unable to create trading session: " + eJBException.toString());
        }
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.context = sessionContext;
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void ejbRemove() {
    }

    public TradeResult put(String string, int n, int n2) throws RemoteException, EJBException {
        Object object;
        try {
            object = this.buyOrderHome.findMatches(string, n, n2);
            if (object.size() > 1) {
                Iterator iterator = object.iterator();
                BuyOrder buyOrder = (BuyOrder)PortableRemoteObject.narrow(iterator.next(), (Class)(class$jwsunleashed$trading$ejb$BuyOrder == null ? (class$jwsunleashed$trading$ejb$BuyOrder = TradingImpl.class$("jwsunleashed.trading.ejb.BuyOrder")) : class$jwsunleashed$trading$ejb$BuyOrder));
                Trade trade = this.tradeHome.create();
                trade.setSellerID(this.currTraderID);
                trade.setBuyerID(buyOrder.getBuyerID());
                trade.setStock(string);
                trade.setShares(n);
                trade.setPrice(n2);
                trade.setTransTime(new Date());
                buyOrder.remove();
                TradeResult tradeResult = new TradeResult();
                tradeResult.status = 1;
                tradeResult.tradeID = (Integer)trade.getPrimaryKey();
                tradeResult.sellerID = this.currTraderID;
                tradeResult.buyerID = trade.getBuyerID();
                tradeResult.tradeType = 1;
                tradeResult.stock = string;
                tradeResult.price = n2;
                tradeResult.shares = n;
                return tradeResult;
            }
        }
        catch (FinderException finderException) {
        }
        catch (CreateException createException) {
            createException.printStackTrace();
        }
        catch (RemoveException removeException) {
            removeException.printStackTrace();
        }
        try {
            object = this.putOrderHome.create();
            object.setSellerID(this.currTraderID);
            object.setStock(string);
            object.setShares(n);
            object.setPrice(n2);
            object.setPutTime(new Date());
            TradeResult tradeResult = new TradeResult();
            tradeResult.status = 2;
            tradeResult.sellerID = this.currTraderID;
            tradeResult.putID = (Integer)object.getPrimaryKey();
            tradeResult.tradeType = 1;
            tradeResult.stock = string;
            tradeResult.price = n2;
            tradeResult.shares = n;
            return tradeResult;
        }
        catch (CreateException createException) {
            createException.printStackTrace();
            throw new EJBException("Unable to create new put order");
        }
    }

    public TradeResult buy(String string, int n, int n2) throws RemoteException, EJBException {
        Object object;
        try {
            object = this.putOrderHome.findMatches(string, n, n2);
            if (object.size() > 1) {
                Iterator iterator = object.iterator();
                PutOrder putOrder = (PutOrder)PortableRemoteObject.narrow(iterator.next(), (Class)(class$jwsunleashed$trading$ejb$PutOrder == null ? (class$jwsunleashed$trading$ejb$PutOrder = TradingImpl.class$("jwsunleashed.trading.ejb.PutOrder")) : class$jwsunleashed$trading$ejb$PutOrder));
                Trade trade = this.tradeHome.create();
                trade.setBuyerID(this.currTraderID);
                trade.setSellerID(putOrder.getSellerID());
                trade.setStock(string);
                trade.setShares(n);
                trade.setPrice(n2);
                trade.setTransTime(new Date());
                putOrder.remove();
                TradeResult tradeResult = new TradeResult();
                tradeResult.status = 1;
                tradeResult.tradeID = (Integer)trade.getPrimaryKey();
                tradeResult.buyerID = this.currTraderID;
                tradeResult.sellerID = trade.getSellerID();
                tradeResult.tradeType = 2;
                tradeResult.stock = string;
                tradeResult.price = n2;
                tradeResult.shares = n;
                return tradeResult;
            }
        }
        catch (FinderException finderException) {
        }
        catch (CreateException createException) {
            createException.printStackTrace();
        }
        catch (RemoveException removeException) {
            removeException.printStackTrace();
        }
        try {
            object = this.buyOrderHome.create();
            object.setBuyerID(this.currTraderID);
            object.setStock(string);
            object.setShares(n);
            object.setPrice(n2);
            object.setBuyTime(new Date());
            TradeResult tradeResult = new TradeResult();
            tradeResult.status = 2;
            tradeResult.buyerID = this.currTraderID;
            tradeResult.buyID = (Integer)object.getPrimaryKey();
            tradeResult.tradeType = 2;
            tradeResult.stock = string;
            tradeResult.price = n2;
            tradeResult.shares = n;
            return tradeResult;
        }
        catch (CreateException createException) {
            createException.printStackTrace();
            throw new EJBException("Unable to create new buy order");
        }
    }

    public TradeResult getPutStatus(int n) throws RemoteException, EJBException {
        Object object;
        PutOrder putOrder = null;
        try {
            putOrder = this.putOrderHome.findByPrimaryKey(new Integer(n));
        }
        catch (FinderException finderException) {
            // empty catch block
        }
        if (putOrder == null) {
            object = null;
            try {
                object = this.tradeHome.findByPutID(n);
            }
            catch (FinderException finderException) {
                // empty catch block
            }
            if (object != null && object.getSellerID() == this.currTraderID) {
                TradeResult tradeResult = new TradeResult();
                tradeResult.status = 1;
                tradeResult.tradeID = (Integer)object.getPrimaryKey();
                tradeResult.sellerID = this.currTraderID;
                tradeResult.buyerID = object.getBuyerID();
                tradeResult.tradeType = 1;
                tradeResult.stock = object.getStock();
                tradeResult.price = object.getPrice();
                tradeResult.shares = object.getShares();
                return tradeResult;
            }
        }
        if (putOrder == null || putOrder.getSellerID() != this.currTraderID) {
            object = new TradeResult();
            ((TradeResult)object).status = 4;
            ((TradeResult)object).putID = n;
            return object;
        }
        object = new TradeResult();
        ((TradeResult)object).status = 2;
        ((TradeResult)object).sellerID = putOrder.getSellerID();
        ((TradeResult)object).putID = (Integer)putOrder.getPrimaryKey();
        ((TradeResult)object).tradeType = 1;
        ((TradeResult)object).stock = putOrder.getStock();
        ((TradeResult)object).price = putOrder.getPrice();
        ((TradeResult)object).shares = putOrder.getShares();
        return object;
    }

    public TradeResult getBuyStatus(int n) throws RemoteException, EJBException {
        Object object;
        BuyOrder buyOrder = null;
        try {
            buyOrder = this.buyOrderHome.findByPrimaryKey(new Integer(n));
        }
        catch (FinderException finderException) {
            // empty catch block
        }
        if (buyOrder == null) {
            object = null;
            try {
                object = this.tradeHome.findByBuyID(n);
            }
            catch (FinderException finderException) {
                // empty catch block
            }
            if (object != null && object.getBuyerID() == this.currTraderID) {
                TradeResult tradeResult = new TradeResult();
                tradeResult.status = 1;
                tradeResult.tradeID = (Integer)object.getPrimaryKey();
                tradeResult.sellerID = object.getSellerID();
                tradeResult.buyerID = this.currTraderID;
                tradeResult.tradeType = 2;
                tradeResult.stock = object.getStock();
                tradeResult.price = object.getPrice();
                tradeResult.shares = object.getShares();
                return tradeResult;
            }
        }
        if (buyOrder == null || buyOrder.getBuyerID() != this.currTraderID) {
            object = new TradeResult();
            ((TradeResult)object).status = 5;
            ((TradeResult)object).buyID = n;
            return object;
        }
        object = new TradeResult();
        ((TradeResult)object).status = 2;
        ((TradeResult)object).buyerID = buyOrder.getBuyerID();
        ((TradeResult)object).buyID = (Integer)buyOrder.getPrimaryKey();
        ((TradeResult)object).tradeType = 2;
        ((TradeResult)object).stock = buyOrder.getStock();
        ((TradeResult)object).price = buyOrder.getPrice();
        ((TradeResult)object).shares = buyOrder.getShares();
        return object;
    }

    public TradeResult retractPut(int n) throws RemoteException, EJBException {
        try {
            PutOrder putOrder = this.putOrderHome.findByPrimaryKey(new Integer(n));
            if (putOrder == null || putOrder.getSellerID() != this.currTraderID) {
                TradeResult tradeResult = new TradeResult();
                tradeResult.status = 4;
                tradeResult.putID = n;
                return tradeResult;
            }
            TradeResult tradeResult = new TradeResult();
            tradeResult.status = 3;
            tradeResult.sellerID = putOrder.getSellerID();
            tradeResult.putID = (Integer)putOrder.getPrimaryKey();
            tradeResult.tradeType = 1;
            tradeResult.stock = putOrder.getStock();
            tradeResult.price = putOrder.getPrice();
            tradeResult.shares = putOrder.getShares();
            putOrder.remove();
            return tradeResult;
        }
        catch (FinderException finderException) {
            TradeResult tradeResult = new TradeResult();
            tradeResult.status = 4;
            tradeResult.putID = n;
            return tradeResult;
        }
        catch (RemoveException removeException) {
            removeException.printStackTrace();
            throw new EJBException("Unable to remove put order");
        }
    }

    public TradeResult retractBuy(int n) throws RemoteException, EJBException {
        try {
            BuyOrder buyOrder = this.buyOrderHome.findByPrimaryKey(new Integer(n));
            if (buyOrder == null || buyOrder.getBuyerID() != this.currTraderID) {
                TradeResult tradeResult = new TradeResult();
                tradeResult.status = 5;
                tradeResult.buyID = n;
                return tradeResult;
            }
            TradeResult tradeResult = new TradeResult();
            tradeResult.status = 3;
            tradeResult.sellerID = buyOrder.getBuyerID();
            tradeResult.buyID = (Integer)buyOrder.getPrimaryKey();
            tradeResult.tradeType = 2;
            tradeResult.stock = buyOrder.getStock();
            tradeResult.price = buyOrder.getPrice();
            tradeResult.shares = buyOrder.getShares();
            buyOrder.remove();
            return tradeResult;
        }
        catch (FinderException finderException) {
            TradeResult tradeResult = new TradeResult();
            tradeResult.status = 5;
            tradeResult.buyID = n;
            return tradeResult;
        }
        catch (RemoveException removeException) {
            removeException.printStackTrace();
            throw new EJBException("Unable to remove buy order");
        }
    }

    public TradeResult[] getOutstandingPuts() throws RemoteException, EJBException {
        try {
            Collection collection = this.putOrderHome.findBySellerID(this.currTraderID);
            Iterator iterator = collection.iterator();
            ArrayList<TradeResult> arrayList = new ArrayList<TradeResult>();
            while (iterator.hasNext()) {
                PutOrder putOrder = (PutOrder)PortableRemoteObject.narrow(iterator.next(), (Class)(class$jwsunleashed$trading$ejb$PutOrder == null ? TradingImpl.class$("jwsunleashed.trading.ejb.PutOrder") : class$jwsunleashed$trading$ejb$PutOrder));
                TradeResult tradeResult = new TradeResult();
                tradeResult.status = 2;
                tradeResult.sellerID = putOrder.getSellerID();
                tradeResult.putID = (Integer)putOrder.getPrimaryKey();
                tradeResult.tradeType = 1;
                tradeResult.stock = putOrder.getStock();
                tradeResult.price = putOrder.getPrice();
                tradeResult.shares = putOrder.getShares();
                arrayList.add(tradeResult);
            }
            return arrayList.toArray(new TradeResult[arrayList.size()]);
        }
        catch (FinderException finderException) {
            finderException.printStackTrace();
            return new TradeResult[0];
        }
    }

    public TradeResult[] getOutstandingBuys() throws RemoteException, EJBException {
        try {
            Collection collection = this.buyOrderHome.findByBuyerID(this.currTraderID);
            Iterator iterator = collection.iterator();
            ArrayList<TradeResult> arrayList = new ArrayList<TradeResult>();
            while (iterator.hasNext()) {
                BuyOrder buyOrder = (BuyOrder)PortableRemoteObject.narrow(iterator.next(), (Class)(class$jwsunleashed$trading$ejb$BuyOrder == null ? TradingImpl.class$("jwsunleashed.trading.ejb.BuyOrder") : class$jwsunleashed$trading$ejb$BuyOrder));
                TradeResult tradeResult = new TradeResult();
                tradeResult.status = 2;
                tradeResult.buyerID = buyOrder.getBuyerID();
                tradeResult.buyID = (Integer)buyOrder.getPrimaryKey();
                tradeResult.tradeType = 2;
                tradeResult.stock = buyOrder.getStock();
                tradeResult.price = buyOrder.getPrice();
                tradeResult.shares = buyOrder.getShares();
                arrayList.add(tradeResult);
            }
            return arrayList.toArray(new TradeResult[arrayList.size()]);
        }
        catch (FinderException finderException) {
            finderException.printStackTrace();
            return new TradeResult[0];
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

