import javafx.application.Application;
import javafx.stage.Stage;
import javafx.scene.Scene;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.geometry.Pos;
import javafx.geometry.Insets;
import javafx.scene.control.Label;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Button;
import javafx.event.EventHandler;
import javafx.event.ActionEvent;

/**
 *  Aplikacja ilustrujca dziaanie kontrolek typu CheckBox.
 */

public class PizzaToppings extends Application
{
   // Pola.
   CheckBox pepperoniCheckBox;
   CheckBox cheeseCheckBox;
   CheckBox anchoviesCheckBox;
   Label totalLabel;
   
   public static void main(String[] args)
   {
      // Uruchamianie aplikacji.
      launch(args);
   }
   
   @Override
   public void start(Stage primaryStage)
   {
      // Tworzenie kontrolek typu CheckBox.
      pepperoniCheckBox = new CheckBox("Pepperoni 3,00 zote");
      cheeseCheckBox = new CheckBox("Ser 2,00 zote");
      anchoviesCheckBox = new CheckBox("Anchois 1,00 zoty");

      // Tworzenie kontrolki typu Button.
      Button totalButton = new Button("Oblicz sum");

      // Rejestrowanie obiektu obsugi zdarze.
      totalButton.setOnAction(new TotalButtonHandler());
      
      // Tworzenie kontrolki typu Label z czn cen.
      totalLabel = new Label("0,00 z");

      // Dodawanie kontrolek typu CheckBox do kontenera typu VBox.
      VBox checkBoxVBox = new VBox(10, pepperoniCheckBox,
                                   cheeseCheckBox, anchoviesCheckBox);
      
      // Tworzenie nastpnego kontenera typu VBox uywanego jako wze korzenia.
      VBox mainVBox = new VBox(10, checkBoxVBox, totalButton,
                               totalLabel);
      
      // Wyrodkowanie zawartoci gwnego kontenera typu VBox.
      mainVBox.setAlignment(Pos.CENTER);
      
      // Ustawienie marginesu w gwnym kontenerze typu VBox na 10 pikseli.
      mainVBox.setPadding(new Insets(10));

      // Tworzenie sceny.
      Scene scene = new Scene(mainVBox);

      // Dodawanie obiektu typu Scene do obiektu typu Stage.
      primaryStage.setScene(scene);
      
      // Wywietlanie okna.
      primaryStage.show();   
   }
   
   /*
    * Klasa obsugi zdarze dla kontrolki totalButton.
    */
    
   class TotalButtonHandler implements EventHandler<ActionEvent>
   {
      @Override
      public void handle(ActionEvent event)
      {
         // Zmienna przechowujca wynik.
         double result = 0;
         
         // Dodawanie dodatkw.
         if (pepperoniCheckBox.isSelected())
            result += 3.0;
         
         if (cheeseCheckBox.isSelected())
            result += 2.0;
         
         if (anchoviesCheckBox.isSelected())
            result += 1.0;
         
         // Wywietlanie wyniku.
         totalLabel.setText(String.format("%,.2f z", result));
      }
   }
}