import javafx.application.Application;
import javafx.stage.Stage;
import javafx.scene.Scene;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.geometry.Pos;
import javafx.geometry.Insets;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Button;
import javafx.event.EventHandler;
import javafx.event.ActionEvent;

/**
 *  Aplikacja do przeliczania kilometrw  wersja z wyraeniem lambda.
 */

public class LambdaKiloConverter extends Application
{
   // Pola.
   private TextField kiloTextField;
   private Label resultLabel;
   
   public static void main(String[] args)
   {
      // Uruchamianie aplikacji.
      launch(args);
   }
   
   @Override
   public void start(Stage primaryStage)
   {
      // Tworzenie kontrolki typu Label do wywietlania pytania.
      Label promptLabel = new Label("Podaj odlego w kilometrach:");

      // Tworzenie kontrolki typu TextField do podawania danych wejciowych.
      kiloTextField = new TextField();

      // Tworzenie przycisku do uruchamiania przelicze.
      Button calcButton = new Button("Przelicz");

      // Tworzenie obiektu obsugi zdarze.
      calcButton.setOnAction(event ->
      {         
         // Pobieranie liczby kilometrw.
         Double kilometers = Double.parseDouble(kiloTextField.getText());
         
         // Przeliczanie kilometrw na mile.
         Double miles = kilometers * 0.6214;
         
         // Wywietlanie wyniku.
         resultLabel.setText(String.format("%,.2f w milach", miles));
      });
      
      // Tworzenie pustej kontrolki typu Label do wywietlania wyniku.
      resultLabel = new Label();

      // Umieszczanie kontrolek promptLabel i kiloTextField w kontenerze typu HBox.
      HBox hbox = new HBox(10, promptLabel, kiloTextField);
      
      // Dodawanie kontrolek HBox, calcButton i resultLabel do kontenera typu VBox.
      VBox vbox = new VBox(10, hbox, calcButton, resultLabel);

      // Wyrodkowanie zawartoci kontenera typu VBox.
      vbox.setAlignment(Pos.CENTER);
      
      // Ustawianie marginesu kontenera typu VBox na 10 pikseli.
      vbox.setPadding(new Insets(10));

      // Tworzenie obiektu typu Scene.
      Scene scene = new Scene(vbox);

      // Dodawanie obiektu typu Scene do obiektu typu Stage.
      primaryStage.setScene(scene);
      
      // Ustawianie tytuu ptna.
      primaryStage.setTitle("Przeliczanie kilometrw");

      // Wywietlanie okna.
      primaryStage.show();   
   }
}