import javafx.application.Application;
import javafx.stage.Stage;
import javafx.scene.Scene;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.geometry.Pos;
import javafx.geometry.Insets;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Button;
import javafx.event.EventHandler;
import javafx.event.ActionEvent;

/**
 *  Aplikacja KiloConverter.
 */

public class KiloConverter extends Application
{
   // Pola.
   private TextField kiloTextField;
   private Label resultLabel;
   
   public static void main(String[] args)
   {
      // Uruchamianie aplikacji.
      launch(args);
   }
   
   @Override
   public void start(Stage primaryStage)
   {
      // Tworzenie kontrolki typu Label w celu wywietlenia pytania.
      Label promptLabel = new Label("Podaj odlego w kilometrach:");

      // Tworzenie kontrolki typu TextField do wprowadzania danych.
      kiloTextField = new TextField();
      
      // Tworzenie przycisku do uruchamiania przeliczania.
      Button calcButton = new Button("Przelicz");

      // Rejestrowanie obiektu obsugi zdarze.
      calcButton.setOnAction(new CalcButtonHandler());
      
      // Tworzenie pustej kontrolki typu Label do wywietlania wynikw.
      resultLabel = new Label();

      // Dodawanie kontrolek promptLabel i kiloTextField do kontenera typu HBox.
      HBox hbox = new HBox(10, promptLabel, kiloTextField);
 
      // Dodawanie kontrolek HBox, calcButton i resultLabel do kontenera typu VBox.
      VBox vbox = new VBox(10, hbox, calcButton, resultLabel);
      
      //Wyrodkowanie zawartoci kontenera typu VBox.
      vbox.setAlignment(Pos.CENTER);

      // Ustawianie marginesu kontenera typu VBox na 10 pikseli.
      vbox.setPadding(new Insets(10));
 
      // Tworzenie obiektu typu Scene.
      Scene scene = new Scene(vbox);

      // Dodawanie obiektu typu Scene do obiektu typu Stage.
      primaryStage.setScene(scene);

      // Ustawianie tytuu ptna.
      primaryStage.setTitle("Przeliczanie kilometrw");

      // Wywietlanie okna.
      primaryStage.show();   
   }
   
   /*
    * Klasa obsugi zdarze dotyczcych kontrolki calcButton.
    */
    
   class CalcButtonHandler implements EventHandler<ActionEvent>
   {
      @Override
      public void handle(ActionEvent event)
      {
         // Pobieranie liczby kilometrw.
        double kilometers = Double.parseDouble(kiloTextField.getText());

        // Przeliczanie kilometrw na mile.
        double miles = kilometers * 0.6214;

        // Wywietlanie wyniku.
        resultLabel.setText(String.format("%,.2f w milach.", miles));
      }
   }
}