import java.io.*;    // Umoliwia uywanie klas File i FileNotFoundException.
import java.util.*;             // Umoliwia uywanie klas Scanner i InputMismatchException.
import javax.swing.JOptionPane; // Umoliwia uywanie klasy JOptionPane.

/**
   Ten program pokazuje, jak przechwytywa wiele wyjtkw
   za pomoc jednej instrukcji try.
*/

public class SalesReport
{
   public static void main(String[] args)
   {
      String filename = "SalesData.txt"; // Nazwa pliku.
      int months = 0;                    // Licznik miesicy.
      double oneMonth;                   // Sprzeda z jednego miesica.
      double totalSales = 0.0;           // czna sprzeda.
      double averageSales;               // rednia sprzeda.

      try
      {
         // Otwieranie pliku.
         File file = new File(filename);
         Scanner inputFile = new Scanner(file);

         // Przetwarzanie zawartoci pliku.
         while (inputFile.hasNext())
         {
            // Pobieranie wartoci sprzeday z danego miesica.
            oneMonth = inputFile.nextDouble();
            
            // Pobieranie wartoci sprzeday z danego miesica.
            totalSales += oneMonth;
            
            // Inkrementacja licznika miesicy.
            months++;
         }

         // Zamykanie pliku.
         inputFile.close();

         // Obliczanie redniej.
         averageSales = totalSales / months;

         // Wywietlanie wynikw.
        JOptionPane.showMessageDialog(null,
           String.format("Liczba miesicy: %d\n" +
                         "czna sprzeda: %,.2f zotych\n" +
                         "rednia sprzeda: %,.2f zotych",
                          months, totalSales, averageSales));
      }
      catch(FileNotFoundException e)
      {
         // Zgaszany przez konstruktor z klasy Scanner, 
       // jeli nie znaleziono plikw.
       JOptionPane.showMessageDialog(null,
          "Plik " + filename + " nie istnieje.");
     }
     catch(InputMismatchException e)
     {
       // Zgaszany przez metod nextDouble klasy Scanner,
       // jeli pobranej wartoci nie mona przeksztaci na liczb.
       JOptionPane.showMessageDialog(null,
           "W pliku znaleziono warto niebdc liczb.");
      }
      
      System.exit(0);
   }
}