/**
   Ta klasa przechowuje dane na temat kursu.
*/

public class Course
{
   private String courseName;      // Nazwa kursu.
   private Instructor instructor; // Wykadowca.
   private TextBook textBook;     // Podrcznik.

   /**
     Ten konstruktor inicjuje pola courseName,
     instructor i textBook.
     @param name Nazwa kursu.
     @param instructor Obiekt typu Instructor.
     @param text Obiekt typu TextBook.
   */

   public Course(String name, Instructor instr,
                 TextBook text)
   {
      // Przypisywanie wartoci do pola courseName.
      courseName = name;

      // Tworzenie nowego obiektu typu Instructor. Jako argument
      // konstruktora kopiujcego przekazywany jest parametr instr.
      instructor = new Instructor(instr);

      // Tworzenie obiektu typu TextBook. Jako argument
      // konstruktora kopiujcego przekazywany jest parametr text.
      textBook = new TextBook(text);
   }

   /**
      Metoda getName.
      @return Nazwa kursu.
   */

   public String getName()
   {
      return courseName;
   }

   /**
      Metoda getInstructor.
      @return Referencja do kopii obiektu typu Instructor
              powizanego z danym kursem.
   */

   public Instructor getInstructor()
   {
      // Zwracanie kopii obiektu instructor.
      return new Instructor(instructor);
   }

   /**
      Metoda getTextBook.
      @return Referencja do kopii obiektu textBook
              z danego kursu.
   */

   public TextBook getTextBook()
   {
      // Zwracanie kopii obiektu textBook.
      return new TextBook(textBook);
   }

   /**
      Metoda toString.
      @return acuch znakw zawierajcy informacje o kursie.
   */

   public String toString()
   {
      // Tworzenie acucha znakw reprezentujcego dany obiekt.
      String str = "Nazwa kursu: " + courseName +
                   "\nInformacje o wykadowcy:\n" +
                   instructor +
                   "\nInformacje o podrczniku:\n" +
                   textBook;

      // Zwracanie acucha znakw.
      return str;
   }
}