import java.util.Scanner;

/**
   Ten program ilustruje metod  
   wyszukiwania binarnego.
*/

public class BinarySearchDemo
{
   public static void main(String[] args)
   {
      // Wartoci w tej tablicy s posortowane
      // rosnco.
      int numbers[] = {101, 142, 147, 189, 199, 207, 222,
                       234, 289, 296, 310, 319, 388, 394,
                       417, 429, 447, 521, 536, 600};
      int result, searchValue;
		String input;
      
      // Tworzenie obiektw do pobierania danych z konsoli.
		Scanner keyboard = new Scanner(System.in);

      do
      {
         // Pobieranie szukanej wartoci.
         System.out.print("Podaj szukan warto: ");
         searchValue = keyboard.nextInt();

         // Wyszukiwanie wartoci.
         result = binarySearch(numbers, searchValue);

        // Wywietlanie wynikw.
        if (result == -1)
           System.out.println("Warto " + searchValue + " nie zostaa znaleziona.");
        else
        {
           System.out.println("Warto " + searchValue + " zostaa znaleziona " +
                              "na pozycji " + result + ".");
        }

		  // Pobieranie pozostaego znaku nowego wiersza.
		  keyboard.nextLine();
		  
        // Czy uytkownik chce ponowi wyszukiwanie?
        System.out.print("Czy chcesz znale inn liczb? (T lub N): ");
        input = keyboard.nextLine();
      } while (input.charAt(0) == 't' || input.charAt(0) == 'T');
   }

   /**
      Metoda binarySearch wykonuje wyszukiwanie binarne w tablicy
      liczb cakowitych. W tablicy szukana jest liczba przekazana
      jako argument value. Jeli program znalaz liczb, zwraca jej indeks
      w tablic. W przeciwnym razie zwracana jest wartos -1; oznacza ona,
      e szukanej wartoci nie znaleziono w tablicy.
      @param array Przeszukiwana tablica.
      @param value Szukana warto.
   */

   public static int binarySearch(int[] array, int value)
   {
      int first;       // Pierwszy element tablicy.
      int last;        // Ostatni element tablicy.
      int middle;      // Punkt rodkowy.
      int position;    // Pozycja szukanej wartoci.
      boolean found;   // Flaga.

      // Ustawianie pocztkowych wartoci.
      first = 0;
      last = array.length - 1;
      position = -1;
      found = false;

      // Szukanie wartoci.
      while (!found && first <= last)
      {
         // Obliczanie punktu rodkowego.
         middle = (first + last) / 2;
         
         // Jeli warto znaleziono w punkcie rodkowym...
         if (array[middle] == value)
         {
            found = true;
            position = middle;
         }
         // w przeciwnym razie jeli warto znajduje si w pierwszej poowie...
         else if (array[middle] > value)
            last = middle - 1;
         // w przeciwnym razie jeli warto znajduje si w drugiej poowie....
         else
            first = middle + 1;
      }

      // Zwracanie pozycji elementu lub -1,
      // jeli wartoci nie znaleziono.
      return position;
   }
}
