/**
   Klasa Dealer utworzona na potrzeby gry Cho-Han.
*/
   
public class Dealer
{
   private int die1Value;  // Warto kostki nr 1.
   private int die2Value; // Warto kostki nr 2.
   
   /**
      Konstruktor.
   */
   
   public Dealer()
   {
      die1Value = 0;
      die2Value = 0;
   }
   
   /**
      Metoda rollDice wykonuje rzut kostkami 
      i zapisuje uzyskane wartoci.
   */
   
   public void rollDice()
   {
      final int SIDES = 6; // Liczba cianek kostek.

      // Tworzenie dwch kostek i wykonywanie rzutw.
      Die die1 = new Die(SIDES);
      Die die2 = new Die(SIDES);
      
      // Zapisywanie wartoci kostek.
      die1Value = die1.getValue();
      die2Value = die2.getValue();
   }
   
   /**
      Metoda getChoOrHan zwraca wynik 
      rzutu kostkami  Cho lub Han.
      @return Zwraca "Cho (parzyste)" lub "Han (nieparzyste)"
   */
   
   public String getChoOrHan()
   {
      String result; // Przechowywanie wyniku.
      
      // Pobieranie sumy oczek. 
      int sum = die1Value + die2Value;
      
      // Okrelanie, czy suma jest parzysta, czy nieparzysta.
      if (sum % 2 == 0)
        result = "Cho (parzyste)";
      else
        result = "Han (nieparzyste)";

      // Zwracanie wyniku.
      return result;
   }
   
   /**
      Metoda getDie1Value zwraca warto rzutu
      kostk nr 1.
      @return Warto pola die1Value 
   */
   
   public int getDie1Value()
   {
      return die1Value;
   }

   /**
      Metoda getDie2Value zwraca warto
      rzutu kostk nr 2.
      @return Warto pola die2Value 
   */
   
   public int getDie2Value()
   {
      return die2Value;
   }
}