import java.util.Scanner;        // Na potrzeby klasy Scanner.
import java.io.*;                // Na potrzeby klas z plikowymi operacjami wejcia-wyjcia.
import javax.swing.JOptionPane;  // Na potrzeby klasy JOptionPane.

/**
   Ten program otwiera plik zawierajcy wartoci
   sprzeday z 30 dni. Program oblicza i wywietla 
   czny poziom sprzeday i redni dzienn.
*/

public class SalesReport
{
   public static void main(String[] args) throws IOException
   {
      final int NUM_DAYS = 30; // Liczba dni z danymi sprzedaowymi.
      String filename;          // Nazwa otwieranego pliku.
      double totalSales;        // czna warto sprzeday z danego okresu.
      double averageSales;      // redni poziom sprzeday.

      // Pobieranie nazwy pliku.
      filename = getFileName();

      // Pobieranie cznej wartoci sprzeday.
      totalSales = getTotalSales(filename);
      
      // Obliczanie redniej.
      averageSales = totalSales / NUM_DAYS;
 
      // Wywietlanie sumy i redniej.
      displayResults(totalSales, averageSales);
      
      System.exit(0);
   }

   /**
      Metoda getFileName wywietla prob o podanie
      nazwy otwieranego pliku.
      @return Referencja do obiektu typu String zawierajcego
            nazw pliku.
   */
   
   public static String getFileName()
   {
      String file;   // Przechowywanie nazwy pliku.
      
      // Wywietlanie proby o podanie nazwy pliku.
      file = JOptionPane.showInputDialog(
               "Podaj nazw pliku zawierajcego\n" +
               "warto sprzeday z 30 dni:");

      // Zwracanie nazwy pliku.
      return file;
   }     
      
   /**
      Metoda getTotalSales otwiera plik, wczytuje
      dzienne kwoty sprzeday i oblicza ich
      sum. Nastpnie zwraca t sum.
      @param filename Nazwa otwieranego pliku.
      @return czna warto sprzeday.
   */
   
   public static double getTotalSales(String filename)throws IOException
   {
      double total = 0.0;  // Akumulator.
      double sales; // Dzienna warto sprzeday.

      // Otwieranie pliku.
      File file = new File(filename);
      Scanner inputFile = new Scanner(file);
      
      // Ta ptla przetwarza wiersze wczytane z pliku i dziaa
      // do momentu dotarcia do koca pliku.
      while (inputFile.hasNext())
      {
        // Wczytywanie z pliku wartoci typu double.
        sales = inputFile.nextDouble();

        // Dodawanie wartoci zmiennej sales do wartoci zapisanej ju w zmiennej total.
         total += sales;
      }
      
      // Zamykanie pliku.
      inputFile.close();
 
      // Zwracanie cznej wartoci sprzeday.
      return total;
   }
   
   /**
      Metoda displayResults wywietla czny i redni
      poziom sprzeday.
      @param total czna warto sprzeday.
      @param avg redni dzienny poziom sprzeday.
   */
   
   public static void displayResults(double total, double avg)
   {
      // Wywietlanie sformatowanego cznego i redniego poziomu sprzeday.
      JOptionPane.showMessageDialog(null,
      String.format("czna sprzeda w podanym okresie wyniosa %,.2f zotego.\n" +
                    "rednia sprzeda dzienna wyniosa %,.2f zotego.",
                       total, avg));
   }
}
