import java.util.Scanner;

/**
   Ten program ilustruje dziaanie 
   rekurencyjnej metody wyszukiwania binarnego.
*/

public class RecursiveBinarySearch
{
   public static void main(String [] args)
   {
      int searchValue;  // Szukana warto.
      int result;      // Wynik wyszukiwania.
      String input;    // Wiersz danych wejciowych.
      char again;      // Przechowywanie jednego znaku.

      // Wartoci w poniszej tablicy 
      // s posortowane rosnco.
      int numbers[] = {101, 142, 147, 189, 199, 207, 222,
                       234, 289, 296, 310, 319, 388, 394,
                       417, 429, 447, 521, 536, 600};

      // Tworzenie obiektu typu Scanner do pobierania danych z klawiatury.
      Scanner keyboard = new Scanner(System.in);
      
      do
      {
         // Pobieranie szukanej wartoci.
        System.out.print("Podaj szukan " +
                         "warto: ");
         searchValue = keyboard.nextInt();

         // Wyszukiwanie wartoci.
         result = binarySearch(numbers, 0, 
                               (numbers.length - 1),
                               searchValue);

         // Wywietlanie wynikw.
         if (result == -1)
         {
            System.out.println(searchValue + 
                               " nie znaleziono.");
         }
         else
         {
            System.out.println(searchValue +
                               " znaleziono " +
                               "na pozycji " + result + ".");
         }

         // Czy uytkownik chce jeszcze raz szuka wartoci?
         System.out.print("Czy chcesz znale inn warto? " +
                          "(T lub N): ");
         // Pobranie znaku nowego wiersza.
         keyboard.nextLine();
         // Wczytywanie wiersza danych wejciowych.
         input = keyboard.nextLine();

       } while (input.charAt(0) == 't' ||
                input.charAt(0) == 'T');
   }

   /**
      Metoda binarySearch wykonuje binarne wyszukiwanie
      w tablicy liczb cakowitych.
      @param array Przeszukiwana tablica.
      @param first Pierwszy element przeszukiwanego przedziau.
      @param last Ostatni element przeszukiwanego przedziau.
      @param value Szukana warto.
      @return Indeks wartoci (jeli j znaleziono)
              lub 1.
   */

   public static int binarySearch(int[] array, int first,
                                  int last, int value)
   {
      int middle;     // Punkt rodkowy w wyszukiwaniu.
 
      // Wykrywanie przypadku bazowego, czyli sytuacji,
      // w ktrej wartoci nie znaleziono.
      if (first > last)
         return -1;
        
      // Obliczanie punktu rodkowego.
      middle = (first + last) / 2;
       
      // Wyszukiwanie wartoci.
      if (array[middle] == value)
         return middle;
      else if (array[middle] < value)
         return binarySearch(array, middle + 1,
                             last, value);
      else
         return binarySearch(array, first,
                             middle - 1, value);
   }
}