/**
   Ta klasa okrela, czy student zaliczy egzamin,
   czy nie zaliczy go.
*/

public class PassFailExam extends PassFailActivity
{
   private int numQuestions;  // Liczba pyta.
   private double pointsEach; // Liczba punktw za pytanie.
   private int numMissed;     // Liczba bdnych odpowiedzi.

   /**
     Konstruktor ustawia liczb pyta, liczb 
     bdnych odpowiedzi i minimaln liczb punktw
     potrzebn do uzyskania zaliczenia.
     @param questions Liczba pyta.
     @param missed Liczba bdnych odpowiedzi.
     @param minPassing Minimalny wynik potrzebny do zaliczenia.
   */

   public PassFailExam(int questions, int missed, 
                       double minPassing)
   {
      // Wywoywanie konstruktora klasy bazowej.
     super(minPassing);

     // Deklarowanie zmiennej lokalnej z wynikiem.
     double numericScore;

     // Ustawianie wartoci pl numQuestions i numMissed.
     numQuestions = questions;
     numMissed = missed;

     // Ustalanie liczby punktw za kade pytanie i
     // wyniku punktowego z egzaminu.
      pointsEach = 100.0 / questions;
      numericScore = 100.0 - (missed * pointsEach);

      // Wywoanie metody setScore klasy bazowej
     // w celu ustawienia wyniku punktowego.
     setScore(numericScore);
   }

   /**
     Metoda getPointsEach zwraca liczb punktw
     za kade pytanie.
     @return Warto w polu pointsEach.
   */

   public double getPointsEach()
   {
      return pointsEach;
   }

   /**
      Metoda getNumMissed zwraca liczb
      bdnych odpowiedzi.
      @return Warto w polu numMissed.
   */

   public int getNumMissed()
   {
      return numMissed;
   }
}