/**
   Ta klasa okrela ocen z egzaminu kocowego.
   Wynik punktowy jest zaokrglany w gr do nastpnej liczby 
   cakowitej, jeli jego cz uamkowa wynosi 0,5 lub wicej.
*/

public class FinalExam2 extends GradedActivity2
{
   private int numQuestions;  // Liczba pyta.
   private double pointsEach; // Liczba punktw za kade pytanie.
   private int numMissed;     // Liczba zych odpowiedzi.

   /**
     Konstruktor ustawia liczb pyta na egzaminie i
     liczb pyta z bdnymi odpowiedziami.
     @param questions Liczba pyta.
     @param missed Liczba bdnych odpowiedzi.
   */

   public FinalExam2(int questions, int missed)
   {
      double numericScore;  // Przechowuje wynik punktowy.

      // Ustawianie wartoci pl numQuestions i numMissed.
      numQuestions = questions;
      numMissed = missed;

      // Okrelanie liczby punktw za kade pytanie
      // i wyniku punktowego z egzaminu.
      pointsEach = 100.0 / questions;
      numericScore = 100.0 - (missed * pointsEach);

      // Wywoanie odziedziczonej metody setScore 
      // w celu zapisania wyniku punktowego.
      setScore(numericScore);

      // Modyfikowanie wyniku.
      adjustScore();
    }

   /**
     Metoda getPointsEach zwraca liczb punktw
     przyznawanych za kade pytanie.
     @return Warto pola pointsEach.
   */

   public double getPointsEach()
   {
      return pointsEach;
   }

   /**
      Metoda getNumMissed zwraca 
      liczb bdnych odpowiedzi.
      @return Warto pola numMissed.
   */

   public int getNumMissed()
   {
      return numMissed;
   }

   /**
      Metoda adjustScore modyfikuje wynik punktowy.
      Jeli cz uamkowa wyniku jest rwna 0,5 lub wicej, 
      metoda zaokrgla wynik w gr.
   */

   private void adjustScore()
   {
      double fraction;

      // Pobieranie czci uamkowej wyniku.
      fraction = score - (int) score;

      // Jeli cz uamkowa wynosi 0,5 lub wicej,
      // wynik jest zaokrglany do nastpnej liczby cakowitej.
      if (fraction >= 0.5)
         score = score + (1.0 - fraction);
   }
}