import java.util.Scanner;

/**
   Ten program zapisuje w tablicy liczb godzin przepracowanych
   przez piciu pracownikw. Kady z nich ma t sam stawk godzinow.
   Nadgodziny s wypacane, gdy liczba przepracowanych godzin przekracza 40.
*/

public class Overtime
{
   public static void main(String[] args)
   {
      final int EMPLOYEES = 5;  // Liczba pracownikw.
      double payRate;           // Stawka godzinowa.
      double grossPay;          // Pensja brutto.
      double overtime;          // Koszt nadgodzin.

      // Tworzenie tablicy do przechowywania liczby przepracowanych godzin.
      int[] hours = new int[EMPLOYEES];

      // Tworzenie obiektu typu Scanner do pobierania danych z klawiatury.
      Scanner keyboard = new Scanner(System.in);

      // Pobieranie liczby godzin przepracowanych przez kadego pracownika.
      System.out.println("Podaj liczb godzin przepracowanych przez " +
                         EMPLOYEES + " pracownikw, z ktrych kady " +
                         "ma t sam stawk godzinow.");

      for (int index = 0; index < EMPLOYEES; index++)
      {
         System.out.print( "Pracownik nr " + (index + 1) + ": ");
         hours[index] = keyboard.nextInt();
      }

      // Pobieranie stawki godzinowej.
      System.out.print("Podaj stawk godzinow pracownikw: ");
      payRate = keyboard.nextDouble();

      // Wywietlanie pensji brutto kadego pracownika.
      System.out.println( "Pensja brutto kadego pracownika: ");
      for (int index = 0; index < EMPLOYEES; index++)
      {
         if (hours[index] > 40)
         {
            // Obliczanie pensji podstawowej.
            grossPay = 40 * payRate;

            // Obliczanie dodatku za nadgodziny.
            overtime = (hours[index] - 40) * (1.5 * payRate);

            // Sumowanie pensji podstawowej i dodatku za nadgodziny.
            grossPay += overtime;
         }
         else
            grossPay = hours[index] * payRate;

         System.out.println("Pracownik nr " + (index + 1) +
                            ": " + grossPay + " z.");
      }
   }
}
