import java.util.Scanner; // Needed for the Scanner class

/**
   Ten program uywa tablicy zawierajcej
   trzy obiekty typu BankAccount.
*/

public class ObjectArray
{
   public static void main(String[] args)
   {
      final int NUM_ACCOUNTS = 3;  // Liczba kont.

      // Tworzenie tablicy wskazujcej 
      // obiekty typu BankAccount.
      BankAccount[] accounts = new BankAccount[NUM_ACCOUNTS];

      // Tworzenie obiektw przechowywanych w tablicy.
      createAccounts(accounts);

      // Wywietlanie stanu kadego konta.
      System.out.println("Oto stan " +
                         "kadego konta:");

      for (int index = 0; index < accounts.length; index++)
      {
         System.out.println("Konto numer " + (index + 1) +
                  ": " + accounts[index].getBalance() + " zotych"); 
      }
   }

   /**
      Metoda createAccounts tworzy obiekt typu BankAccount
      odpowiadajcy kademu elementowi tablicy. Uytkownik
      widzi prob o podanie stanu kadego z tych kont.
      @param array Tablica z elementami wskazujcymi konta.
   */

   private static void createAccounts(BankAccount[] array)
   {
      double balance;  // Przechowywanie stanu konta.

      // Tworzenie obiektu typu Scanner.
      Scanner keyboard = new Scanner(System.in);

      // Tworzenie kont.
      for (int index = 0; index < array.length; index++)
      {
         // Pobieranie stanu konta.
        System.out.print("Podaj stan " +
                         "konta numer " + (index + 1) + ": ");
        balance = keyboard.nextDouble();

        // Tworzenie konta.
         array[index] = new BankAccount(balance);
      }
   }
}