/**
   Klasa Grader oblicza redni wartoci
   z tablicy z wynikami testw po
   odrzuceniu najniszego wyniku.
*/

public class Grader
{
   // Pole testScores to zmienna 
   // wskazujca tablic
   // z wynikami testw.
   private double[] testScores;
   
   /**
      Konstruktor
      @param scoreArray Tablica z wynikami testw.
   */
   
   public Grader(double[] scoreArray)
   {
      // Przypisywanie podanej jako argument tablicy 
      // do pola testScores.
      testScores = scoreArray;
   }
   
   /**
      Metoda getLowestScore.
      @return Najniszy wynik testu.
   */
   
   public double getLowestScore()
   {
      double lowest;    // Przechowywanie najniszego wyniku.
 
      // Pobieranie pierwszego wyniku testu z tablicy.
      lowest = testScores[0];

      // Pobieranie kolejnych elementw tablicy. Po 
      // napotkaniu wyniku niszego ni warto zmiennej 
      // lowest naley przypisa go do tej zmiennej.
      for (int index = 1; index < testScores.length; index++)
      {
         if (testScores[index] < lowest)
            lowest = testScores[index];
      }
      
      // Zwracanie najniszego wyniku testu.
      return lowest;
   }
   
   /**
      Metoda getAverage.
     @return rednia wynikw testw
             po odrzuceniu najniszego wyniku.
   */
   
   public double getAverage()
   {
      double total = 0;   // Przechowywanie sumy wynikw.
      double lowest;     // Przechowywanie najniszego wyniku.
      double average;    // Przechowywanie redniej.

      // Jeli tablica zawiera mniej ni dwa wyniki testw,
      // naley wywietli komunikat o bdzie i przypisa
      // 0 do redniej.
      if (testScores.length < 2)
      {
        System.out.println("BD: Trzeba poda przynajmniej " +
                           "dwa wyniki testw!"); 
         average = 0;
      }
      else
      {
         // Najpierw naley obliczy sum wynikw.
         for (double score : testScores)
            total += score;
            
         // Nastpnie pobierany jest najniszy wynik.
         lowest = getLowestScore();

         // Odejmowanie najniszego wyniku od sumy.
         total -= lowest;

         // Pobieranie redniej dla zmodyfikowanego zbioru wyniku.
         average = total / (testScores.length - 1);
      }
      
      // Zwracanie redniej dla zmodyfikowanego zbioru wyniku.
      return average;
   }
}