import javafx.application.Application;
import javafx.stage.Stage;
import javafx.scene.Scene;
import javafx.scene.control.TextArea;
import javafx.scene.control.Button;
import javafx.scene.layout.VBox;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.event.EventHandler;
import javafx.event.ActionEvent;
import java.sql.*;

public class DBViewer extends Application
{
   // Adres URL bazy danych.
   final String DB_URL = "jdbc:derby:CoffeeDB";
   
   // Kontrolki do pobierania i wywietlania danych.
   TextArea queryTextArea;
   TextArea resultsTextArea;
      
   public static void main(String[] args)
   {
      // Uruchamianie aplikacji.
      launch(args);
   }
   
   @Override
   public void start(Stage primaryStage)
   {
      final int COL_SIZE = 50;
      final int ROW_SIZE = 10;
      final double SPACING = 10.0;
      
      // Tworzenie obszaru do wprowadzania danych.
      queryTextArea = new TextArea();
      queryTextArea.setPrefColumnCount(COL_SIZE);
      queryTextArea.setPrefRowCount(ROW_SIZE);
      
      // Tworzenie obszaru na wyniki zapytania.
      resultsTextArea = new TextArea();
      resultsTextArea.setPrefColumnCount(COL_SIZE);
      resultsTextArea.setPrefRowCount(ROW_SIZE);
      
      // Tworzenie przycisku Przelij.
      Button submitButton = new Button("Przelij");
      submitButton.setOnAction(new SubmitButtonHandler());
      
      // Umieszczanie kontrolek w kontenerze typu VBox.
      VBox vbox = new VBox(SPACING, queryTextArea,
                           submitButton, resultsTextArea);
      vbox.setAlignment(Pos.CENTER);
      vbox.setPadding(new Insets(SPACING));
      
      // Podawanie nagwka.
      primaryStage.setTitle("Podawanie zapytania SELECT");

      // Tworzenie sceny i przypisywanie jej do ptna.
      Scene scene = new Scene(vbox);
      primaryStage.setScene(scene);
      
      // Wywietlanie ptna.
      primaryStage.show();
   }

   /**
    * Klasa obsugi zdarze przycisku submitButton.
    */
 
   class SubmitButtonHandler implements EventHandler<ActionEvent>
   {
      @Override
      public void handle(ActionEvent event)
      {
         try
         {
            // Usuwanie wczeniejszych wynikw.
            resultsTextArea.setText("");
            
            // Nawizywanie poczenia z baz danych.
            Connection conn = DriverManager.getConnection(DB_URL);
            
            // Tworzenie obiektu typu Statement.
            Statement stmt = conn.createStatement();
            
            // Wykonywanie zapytania.
            ResultSet resultSet = 
                    stmt.executeQuery(queryTextArea.getText());
            
            // Pobieranie metadanych zbioru wynikw.
            ResultSetMetaData meta = resultSet.getMetaData();
            
            // Tworzenie acucha znakw przeznaczonego na wyniki.
            String output = "";
            
            // Pobieranie wynikw.
            while (resultSet.next())
            {               
               // Pobieranie wszystkich kolumn wiersza.
               for (int i = 1; i <= meta.getColumnCount(); i++)
               {
                  output += resultSet.getString(i);
                  output += '\t';
               }
               output += '\n';
            }
            
            // Wywietlanie wynikw.
            resultsTextArea.setText(output);
   
            // Zamykanie obiektu stmt i poczenia.
            stmt.close();
            conn.close();
 
         }
         catch (SQLException e)
         {
            e.printStackTrace();
            System.exit(0);
         }
      }
   }
}
