import javafx.application.Application;
import javafx.stage.Stage;
import javafx.scene.Scene;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.geometry.Pos;
import javafx.geometry.Insets;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Button;
import javafx.event.EventHandler;
import javafx.event.ActionEvent;

/**
 *  Aplikacja do przeliczania kilometrw z debugowaniem z uyciem konsoli.
 */

public class ConsoleDebugging extends Application
{
   // Pola.
   private TextField kiloTextField;
   private Label resultLabel;
   
   public static void main(String[] args)
   {
      // Uruchamianie aplikacji.
      launch(args);
   }
   
   @Override
   public void start(Stage primaryStage)
   {
      // Tworzenie obiektu typu Label do wywietlania informacji.
      Label promptLabel = new Label("Wpisz odlego w kilometrach:");

      // Tworzenie kontrolki typu TextField na dane wejciowe.
      kiloTextField = new TextField();

      // Tworzenie przycisku do uruchamiania przelicze.
      Button calcButton = new Button("Przelicz");

      // Tworzenie obiektu obsugi zdarze.
      calcButton.setOnAction(event ->
      {
         // Na potrzeby debugowania wywietlany jest wpisany tekst i
         // jego warto przeksztacona na typ double.
         System.out.printf("Wczytano %s z pola tekstowego. \n",
                           kiloTextField.getText());
         System.out.printf("Warto po przeksztaceniu: %f.\n",
                           Double.parseDouble(kiloTextField.getText()));

         // Pobieranie liczby kilometrw.
         Double kilometers = Double.parseDouble(kiloTextField.getText());
         
         // Przeliczanie kilometrw na mile.
         Double miles = kilometers * 0.6214;
         
         // Wywietlanie wynikw.
         resultLabel.setText(String.format("%,.2f w milach", miles));
  
         // Na potrzeby debugowania wywietlany jest komunikat z informacj,
         // e aplikacja jest gotowa na pobranie nastpnych danych wejciowych.
         System.out.println("Mona wpisa kolejne dane wejciowe.");
       });

      // Tworzenie pustej kontrolki typu Label do wywietlania wynikw.
      resultLabel = new Label();
      
      // Umieszczanie kontrolek promptLabel i kiloTextField w kontenerze typu HBox.
      HBox hbox = new HBox(10, promptLabel, kiloTextField);

      // Umieszczanie kontenera typu HBox i kontrolek calcButton oraz resultLabel do kontenera typu VBox.
      VBox vbox = new VBox(10, hbox, calcButton, resultLabel);

      // Wyrodkowanie zawartoci kontenera typu VBox.
      vbox.setAlignment(Pos.CENTER);
      
      // Ustawianie marginesu kontenera typu VBox na 10 pikseli.
      vbox.setPadding(new Insets(10));

      // Tworzenie obiektu typu Scene.
      Scene scene = new Scene(vbox);

      // Dodawanie obiektu typu Scene do obiektu typu Stage.
      primaryStage.setScene(scene);
      
      // Ustawianie tytuu ptna.
      primaryStage.setTitle("Przeliczanie kilometrw");

      // Wywietlanie okna.
      primaryStage.show();   
   }
}