/**
   Ta klasa oblicza ocen po modyfikacji wyniku. Jest to
   rozszerzenie klasy GradedActivity.
*/

public class CurvedActivity extends GradedActivity
{
   double rawScore;     // Niezmodyfikowany wynik.
   double percentage; // Procent okrelajcy poziom modyfikacji.

   /**
     Konstruktor ustawia procent okrelajcy poziom modyfikacji.
     @param percent Procent okrelajcy poziom modyfikacji.
   */

   public CurvedActivity(double percent)
   {
      percentage = percent;
      rawScore = 0.0;
   }

   /**
      Ta metoda setScore przesania metod setScore z klasy bazowej. 
      Ta wersja przyjmuje argument w postaci pierwotnego wyniku. Ta warto
      jest mnoona przez procent okrelajcy poziom modyfikacji, a wynik
      jest przekazywany jako argument do metody setScore klasy bazowej.
      @param s Pierwotny wynik.
   */
   
   @Override
   public void setScore(double s)
   {
      rawScore = s;
      super.setScore(rawScore * percentage);
   }

   /**
      Metoda getRawScore zwraca pierwotny wynik.
      @return Warto w polu rawScore.
   */

   public double getRawScore()
   {
      return rawScore;
   }

   /**
      Metoda getPercentage zwraca procent okrelajcy
      poziom modyfikacji wynikw.
      @return Warto pola percentage.
   */

   public double getPercentage()
   {
      return percentage;
   }
}