package javaxml3;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;


// Import parsera.
import org.apache.xerces.parsers.DOMParser;

import org.w3c.dom.Document;

import org.xml.sax.InputSource;


public class SerializeTester {

	// Plik do odczytu.
    private File inputXML;

	// Plik do zapisu.
    private File outputXML;

    public SerializeTester(File inputXML) {
        this.inputXML = inputXML;
    }

    public void test(OutputStream outputStream)
              throws Exception {

        DOMParser parser = new DOMParser();

		// Pozyskanie drzewa DOM w postaci obiektu Document.
        parser.parse(new InputSource(new FileInputStream(inputXML)));

        Document doc = parser.getDocument();

        // Serializacja
        DOMSerializer serializer = new DOMSerializer();
        serializer.setIndent(2);
        serializer.serialize(doc, outputStream);
    }

    public static void main(String[] args) {

        if (args.length != 2) {
            System.out.println(
                    "Usage: java javaxml3.SerializeTester " + 
                    "[XML document to read] " + 
                    "[filename to write output to]");

            return;
        }

        try {

            SerializeTester tester = new SerializeTester(new File(args[0]));
            tester.test(new FileOutputStream(new File(args[1])));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}