package javaxml3;

import java.io.OutputStreamWriter;

import com.sun.syndication.feed.module.itunes.EntryInformation;
import com.sun.syndication.feed.module.itunes.EntryInformationImpl;
import com.sun.syndication.feed.module.itunes.FeedInformation;
import com.sun.syndication.feed.module.itunes.FeedInformationImpl;
import com.sun.syndication.feed.module.itunes.types.Category;
import com.sun.syndication.feed.module.itunes.types.Subcategory;
import com.sun.syndication.feed.rss.Channel;
import com.sun.syndication.feed.rss.Description;
import com.sun.syndication.feed.rss.Enclosure;
import com.sun.syndication.feed.rss.Item;
import com.sun.syndication.io.WireFeedOutput;

public class ITunesExample {

    /**
     * @param args
     */
    public static void main(String[] args) throws Exception {
        Channel channel = new Channel("rss_2.0");
		channel.setTitle("Przykadowe rdo podcastw.");
		channel.setDescription("Opis przykadowego podcastu.");
        channel.setLink("http://www.przyklad.org");

        FeedInformation feedInfo = new FeedInformationImpl();
        channel.getModules().add(feedInfo);
        feedInfo.setKeywords(new String[] { "Przykad", "Java", "XML" });
        feedInfo.setOwnerEmailAddress("podcasts@przyklad.org");
		feedInfo.setOwnerName("Waciciel Podcastu");

        Category category = new Category("Technology");
        category.setSubcategory(new Subcategory("Podcasting"));
        feedInfo.getCategories().add(category);
        feedInfo.getCategories().add(new Category("Comedy"));

        Item item = new Item();
		item.setTitle("Mj pierwszy podcast.");

        Description description = new Description();
        description.setType("text");
		description.setValue("Mj pierwszy w yciu podcast.");
        item.setDescription(description);

        Enclosure enclosure = new Enclosure();
        enclosure.setUrl("http://www.przyklad.org/podcast/ep1.mp3");
        enclosure.setType("audio/mpeg");
        enclosure.setLength(4182295);
        item.getEnclosures().add(enclosure);

        EntryInformation entryInfo = new EntryInformationImpl();
        entryInfo.setKeywords(new String[] { "Education" });
        entryInfo.setAuthor("learning@przyklad.org");
        item.getModules().add(entryInfo);

        channel.getItems().add(item);

        WireFeedOutput outputter = new WireFeedOutput();
        outputter.output(channel, new OutputStreamWriter(System.out));
    }
}
