package javaxml3.icbm.io;

import java.util.Collections;
import java.util.Set;

import javaxml3.icbm.ICBMModule;

import org.jdom.Element;
import org.jdom.Namespace;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.io.ModuleGenerator;

public class ICBMGenerator implements ModuleGenerator {

    private static final Namespace ICBM_NS = Namespace.getNamespace(
            ICBMModule.PREFIX, ICBMModule.URI);

    private static final Set NS_SET = Collections.singleton(ICBM_NS);

    public void generate(Module module, Element element) {
        ICBMModule icbm = (ICBMModule) module;

        Element latitude = new Element("latitude", ICBM_NS);
        latitude.setText(Float.toString(icbm.getLatitude()));
        element.addContent(latitude);

        Element longitude = new Element("longitude", ICBM_NS);
        longitude.setText(Float.toString(icbm.getLongitude()));
        element.addContent(longitude);
    }

    public Set getNamespaces() {
        return NS_SET;
    }

    public String getNamespaceUri() {
        return ICBMModule.URI;
    }

}
