package javaxml3;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.xml.sax.InputSource;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;

public class SimpleAggregator2 {

    private SyndFeedInput feedInput;

    public SimpleAggregator2() {
        feedInput = new SyndFeedInput();
    }

    private int acceptUserChoice(int menuLength) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(
                System.in));
        System.out.print(">");
        String choice = null;
        try {
            choice = reader.readLine();
        } catch (IOException e) {
			System.err.println("Nie mona odczyta wybranej pozycji.");
            return 0;
        }
        try {
            int choiceInt = Integer.parseInt(choice);
            if (choiceInt > menuLength)
                return 0;
            else
                return choiceInt;
        } catch (NumberFormatException e) {
            return 0;
        }
    }

    private void sort(List entryList) {
        Collections.sort(entryList, new Comparator() {

            public int compare(Object arg0, Object arg1) {
                SyndEntry entry0 = (SyndEntry) arg0;
                SyndEntry entry1 = (SyndEntry) arg1;
                if (entry0.getPublishedDate() == null)
                    return -1;
                if (entry1.getPublishedDate() == null)
                    return 1;

                return entry1.getPublishedDate().compareTo(
                        entry0.getPublishedDate());
            }
        });
    }

    private List loadFeeds(String[] feedURLs) {
        List allEntries = new ArrayList();
        for (int i = 0; i < feedURLs.length; i++) {
            String feedURL = feedURLs[i];
			System.out.println("adowanie rda z: " + feedURL + ".....");
            SyndFeed feed = null;
            try {
                feed = feedInput.build(new InputSource(feedURL));
            } catch (IllegalArgumentException e) {
				System.err.println("Nie mona przetworzy rda z: " + feedURL);
                e.printStackTrace();
            } catch (FeedException e) {
				System.err.println("Nie mona przetworzy rda z: " + feedURL);
                e.printStackTrace();
            }
			System.out.println("Znaleziono rdo typu  " + feed.getFeedType());
			System.out.println("Tytu rda: " + feed.getTitle());

            List entryList = feed.getEntries();
            if (!entryList.isEmpty()) {
                int entryListLength = Math.min(entryList.size(), 5);
                entryList = entryList.subList(0, entryListLength);
                allEntries.addAll(entryList);
            }
        }
        return allEntries;
    }

    private void outputEntry(SyndEntry entry) {
        System.out.println("Tytu: " + entry.getTitle());
        System.out.println("Opis: " + entry.getDescription().getValue());
        System.out.println("Adres: " + entry.getLink());
    }

    private void outputMenu(List allEntries) {
        for (int i = 0; i < allEntries.size(); i++) {
            SyndEntry entry = (SyndEntry) allEntries.get(i);
            System.out.println("#" + (i + 1) + ": " + entry.getTitle());
        }
    }

    private void run(String[] args) {
		System.out.println("Witaj w Prostym Agregatorze.");

        List allEntries = loadFeeds(args);

		System.out.println("Zaadowano rda.");
        System.out.println();

        sort(allEntries);

		System.out.println("Wybierz jedn z poniszych pozycji:");

        outputMenu(allEntries);

        int choice = acceptUserChoice(allEntries.size());

        if (choice > 0) {
			System.out.println("Wybrano pozycj numer #:" + choice);
            SyndEntry entry = (SyndEntry) allEntries.get(choice - 1);
            outputEntry(entry);
        }

    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Uycie: java javaxml3.SimpleAggregator [URLs]");
            return;
        }

        SimpleAggregator2 aggregator = new SimpleAggregator2();
        aggregator.run(args);

    }

}
