package net.jcip.examples;

import net.jcip.annotations.*;

/**
 * UnsafeLazyInitialization
 * <p/>
 * Niebezpieczna inicjalizacja leniwa
 *
 * @author Brian Goetz i Tim Peierls
 */
@NotThreadSafe
public class UnsafeLazyInitialization {
    private static Resource resource;

    public static Resource getInstance() {
        if (resource == null)
            resource = new Resource(); // niebezpieczna publikacja
        return resource;
    }

    static class Resource {
    }
}
